/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.starteam;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.starteam.StarTeamRepositoryProxy;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class StarTeamProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private StarTeamRepositoryProxy proxy;
    private String workingViewName;
    private String rootRelativePath;
    private String userName;
    private String password;
    private String checkinCondition = "build.successful";
    private String checkinComment;

    public StarTeamProofBuildSupport(StarTeamRepositoryProxy proxy) {
        this.proxy = proxy;
    }

    @Editable(order=100, name="Working View", description="Specify the working view at user's desktop. Changes that have not been checked in will be collected from this view and send to build grid to run a proof build.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get name of the working view at user's desktop.")
    public String getWorkingViewName() {
        return this.workingViewName;
    }

    public void setWorkingViewName(String workingViewName) {
        this.workingViewName = workingViewName;
    }

    @Editable(order=110, description="Specify the relative path between working view root and the build view root. This property is used to make sure that changed files in working view are copied to correct position in the build view. For example, if the build view is rooted at <b>/foo/bar</b>, and the working view is rooted at <b>/foo/bar/hello/world</b>, the root relative path should then be specified as <b>hello/world</b>. If left empty, QuickBuild will assume that the working view and build view has the same root.")
    @Scriptable
    @ScriptApi(value="Get relative path between working view root and build view root. Null if working view and build view has the same root.")
    public String getRootRelativePath() {
        return this.rootRelativePath;
    }

    public void setRootRelativePath(String rootRelativePath) {
        this.rootRelativePath = rootRelativePath;
    }

    @Editable(order=200, description="Specify StarTeam user name to be used at user's desktop. If left empty, user name specified at repository level will be used.")
    @ScriptApi(value="Get user name to be used at user's desktop. Null if not specified.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=250, description="Specify StarTeam password to be used at user's desktop. If left empty, password specified at repository level will be used.")
    @Password
    @ScriptApi(value="Get password to be used at user's desktop. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=300, description="Specify the condition to checkin local change. If this condition is satisfied, change in the working view will be checked in after the build finishes.")
    @Expressions(value={"checkin only when build is successful", "build.successful", "always checkin", "true", "do not checkin", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to checkin local change after build finishes.")
    @Scriptable
    public String getCheckinCondition() {
        return this.checkinCondition;
    }

    public void setCheckinCondition(String checkinCondition) {
        this.checkinCondition = checkinCondition;
    }

    @Editable(order=400, description="Specify the comment when checkin the local change. This property only takes effect if the checkin condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get the comment to checkin local change after build finishes. Null if not specified.")
    @Scriptable
    public String getCheckinComment() {
        return this.checkinComment;
    }

    public void setCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        Boolean isCheckin = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getCheckinCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isCheckin.booleanValue()) {
            Context.getLogger().info("Checkin modified files...");
            View view = null;
            try {
                view = this.openWorkingView();
                Folder rootFolder = view.getRootFolder();
                Context.getLogger().info("Caching item props of working folder tree...");
                this.proxy.getRepository().cacheItemProps(rootFolder);
                if (this.getCheckinComment() != null) {
                    this.checkinFolder(rootFolder, this.getCheckinComment());
                } else {
                    this.checkinFolder(rootFolder, "Checkin by QuickBuild as result of proof build.");
                }
            }
            finally {
                if (view != null) {
                    view.getServer().disconnect();
                    view = null;
                }
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return this.proxy.getRepository().getCheckoutFile(repositoryPath);
    }

    private View openWorkingView() {
        String viewUrl = this.proxy.getRepository().getProjectUrl(this.getUserName() != null ? this.getUserName() : this.proxy.getRepository().getUserName(), this.getPassword() != null ? this.getPassword() : this.proxy.getRepository().getPassword()) + "/" + this.getWorkingViewName();
        View view = StarTeamFinder.openView((String)viewUrl);
        if (view == null) {
            throw new QuickbuildException("Can not find view '" + viewUrl + "'.");
        }
        return view;
    }

    private void examineFolder(Folder folder, LocalChange change, File changeStoreDir, List<String> merges) {
        for (Folder folder2 : folder.getSubFolders()) {
            this.examineFolder(folder2, change, changeStoreDir, merges);
        }
        try {
            folder.getServer().getTypeNames().getClass();
            for (Folder folder3 : folder.getItems("File")) {
                com.starbase.starteam.File file = (com.starbase.starteam.File)folder3;
                int fileStatus = file.getStatus();
                if (fileStatus == 1) {
                    merges.add(file.getFullName());
                    continue;
                }
                if (fileStatus != 3) continue;
                String relativePath = FileUtils.getRelativePath((String)file.getFullName(), (String)folder.getView().getRootFolder().getPath());
                Validate.isTrue((boolean)StringUtils.isNotBlank((String)relativePath));
                String repositoryPath = this.getRootRelativePath() != null ? StringUtils.strip((String)this.getRootRelativePath().replace('\\', '/'), (String)"/") + relativePath : relativePath.substring(1);
                change.getModifyPaths().add(repositoryPath);
                FileUtils.copyFile((File)new File(file.getFullName()), (File)change.getStoredFile(changeStoreDir, repositoryPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkinFolder(Folder folder, String comment) {
        for (Folder folder2 : folder.getSubFolders()) {
            this.checkinFolder(folder2, comment);
        }
        try {
            folder.getServer().getTypeNames().getClass();
            for (Folder folder3 : folder.getItems("File")) {
                com.starbase.starteam.File file = (com.starbase.starteam.File)folder3;
                if (file.getStatus() != 3) continue;
                file.checkin(comment, Item.LockType.UNLOCKED, false, true, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChange getLocalChange(File changeStoreDir) {
        View view = null;
        try {
            view = this.openWorkingView();
            Folder rootFolder = view.getRootFolder();
            Context.getLogger().info("Caching item props of working folder tree...");
            this.proxy.getRepository().cacheItemProps(rootFolder);
            LocalChange change = new LocalChange();
            ArrayList<String> merges = new ArrayList<String>();
            Context.getLogger().info("Examining working view to get modified files...");
            this.examineFolder(rootFolder, change, changeStoreDir, merges);
            if (!merges.isEmpty()) {
                throw new QuickbuildException("Below files have new tip version checked in. Please merge them first:\n" + StringUtils.join(merges, (String)","));
            }
            LocalChange localChange = change;
            return localChange;
        }
        finally {
            if (view != null) {
                view.getServer().disconnect();
                view = null;
            }
        }
    }
}

