/*
 * Decompiled with CFR 0.152.
 */
package com.example.myplugin;

import com.example.myplugin.MyStatistics;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;

public class MyMetricsCollector
implements StatisticsSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatistics(Build build) {
        File msgFile = new File(build.getPublishDir(), "myplugin/message.txt");
        if (msgFile.exists()) {
            int msgLen = FileUtils.readFileAsString((File)msgFile).length();
            File statsDir = new File(build.getConfiguration().getPublishDir(), "myplugin");
            Lock lock = LockUtils.lockForWrite((File)statsDir);
            try {
                FileUtils.createDir((File)statsDir);
                File statsFile = new File(statsDir, "statistics.xml");
                MyStatistics stats = statsFile.exists() ? (MyStatistics)BeanUtils.readFile((File)statsFile) : new MyStatistics();
                stats.getMsgLens().put(build.getVersion(), msgLen);
                BeanUtils.writeFile((Object)stats, (File)statsFile);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStatistics(Configuration configuration) {
        File statsDir = new File(configuration.getPublishDir(), "myplugin");
        Lock lock = LockUtils.lockForWrite((File)statsDir);
        try {
            FileUtils.deleteDir((File)statsDir);
        }
        finally {
            lock.unlock();
        }
    }

    public String getStatisticsName() {
        return "My Metrics";
    }
}

