/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco.renderer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageLevel;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoLine;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoPluginSetting;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JacocoViewSourceLinkItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public JacocoViewSourceLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public boolean isEnabled(ItemContext context) {
        return !Strings.isNullOrEmpty((String)context.getDataRow().getString("fileName"));
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new JacocoSourceViewPage(Context.getBuild().getId(), title, sourceType, lines, blocks, startLine);
    }

    static CoverageLevel getLevel(double coverage, List<CoverageLevel> levels) {
        for (CoverageLevel each : levels) {
            if (!(coverage >= each.getThreshold())) continue;
            return each;
        }
        throw new IllegalArgumentException("Invalid coverage level definition " + levels + ", coverage: " + coverage);
    }

    private String getBackgroundColor(JacocoLine line, List<CoverageLevel> levels) {
        CoverageLevel level = line.getBranchesTotal() > 0 ? JacocoViewSourceLinkItem.getLevel(line.getBranchCoverage(), levels) : JacocoViewSourceLinkItem.getLevel(line.getInstructionCoverage(), levels);
        return level.getColor();
    }

    private List<CoverageLevel> lightColorLevels(JacocoPluginSetting setting) {
        ArrayList levels = Lists.newArrayList();
        CoverageLevel level = setting.getLevelHigh();
        String c = level.getColor();
        String high = this.getLightColor(c);
        levels.add(new CoverageLevel(level.getLevelName(), level.getThreshold(), high));
        level = setting.getLevelMedium();
        c = level.getColor();
        String medium = this.getLightColor(c);
        levels.add(new CoverageLevel(level.getLevelName(), level.getThreshold(), medium));
        level = setting.getLevelNormal();
        String normal = this.getLightColor(level.getColor());
        levels.add(new CoverageLevel(level.getLevelName(), level.getThreshold(), normal));
        level = setting.getLevelLow();
        String low = this.getLightColor(level.getColor());
        levels.add(new CoverageLevel(level.getLevelName(), level.getThreshold(), low));
        return ImmutableList.copyOf((Collection)levels);
    }

    private String getLightColor(String c) {
        if (!c.startsWith("#")) {
            c = "#" + c;
        }
        Color color = Color.decode(c);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(r, g, b, hsbvals);
        float bright = Math.min(hsbvals[2] + 0.4f, 0.98f);
        float s = Math.max(hsbvals[1] - 0.7f, 0.1f);
        color = Color.getHSBColor(hsbvals[0], s, bright);
        return JacocoViewSourceLinkItem.toCssColor(color);
    }

    public static String toCssColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private String getColor(JacocoLine line, JacocoPluginSetting setting) {
        double instructionCoverage = line.getInstructionCoverage();
        double branchCoverage = line.getBranchCoverage();
        if (line.getBranchesTotal() > 0) {
            return setting.getCoverageColor(branchCoverage);
        }
        return setting.getCoverageColor(instructionCoverage);
    }

    private class JacocoSourceViewPage
    extends SourceViewPage {
        private static final long serialVersionUID = 1L;
        final Long buildId;

        JacocoSourceViewPage(long buildId, String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
            super(title, sourceType, lines, blocks, startLine);
            this.buildId = buildId;
        }

        protected String renderContent(String[] lines, Block[] blocks) {
            StringBuffer sb = new StringBuffer();
            Build build = (Build)BuildManager.instance.get(this.buildId);
            JacocoPluginSetting setting = JacocoPluginSetting.get(build.getConfiguration());
            List lightLevels = JacocoViewSourceLinkItem.this.lightColorLevels(setting);
            int i = 1;
            sb.append("<table>");
            if (blocks.length > 0) {
                for (Block each : blocks) {
                    while (i < each.getStartLine() && i <= lines.length) {
                        sb.append("<tr>");
                        sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                        sb.append("<td class='hits'></td>");
                        sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                        sb.append("</tr>");
                        ++i;
                    }
                    JacocoLine block = (JacocoLine)each;
                    String color = JacocoViewSourceLinkItem.this.getColor(block, setting);
                    String message = JacocoSourceViewPage.escapeMessage((String)block.toString());
                    while (i <= each.getEndLine() && i <= lines.length) {
                        sb.append("<tr>");
                        sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                        sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">");
                        if (i == each.getStartLine()) {
                            if (block.getBranchesTotal() > 0 && block.getBranchCoverage() < 1.0) {
                                sb.append(DataTypes.PERCENT.asString((Object)block.getBranchCoverage()));
                            } else if (block.getInstructionsTotal() > 0 && block.getInstructionCoverage() < 1.0) {
                                sb.append(DataTypes.PERCENT.asString((Object)block.getInstructionCoverage()));
                            } else {
                                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                            }
                        } else {
                            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                        }
                        String colorfulLine = "<span style='background:" + JacocoViewSourceLinkItem.this.getBackgroundColor(block, lightLevels) + "'>" + lines[i - 1] + "</span>";
                        sb.append("</div>").append("</td>");
                        sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(colorfulLine).append("</span>").append("</td>");
                        sb.append("</tr>");
                        ++i;
                    }
                }
            }
            while (i <= lines.length) {
                sb.append("<tr>");
                sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                if (blocks.length > 0) {
                    sb.append("<td class='hits'></td>");
                }
                sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                sb.append("</tr>");
                ++i;
            }
            sb.append("</table>");
            return sb.toString();
        }
    }
}

