/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoLine;
import com.pmease.quickbuild.plugin.report.jacoco.parser.JavaNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class JacocoParser {
    private static void parseCoverages(Element node, DataRow row) {
        List nodes = node.selectNodes("./counter");
        for (Element each : nodes) {
            String str = each.attributeValue("type");
            int missed = Integer.valueOf(each.attributeValue("missed"));
            int covered = Integer.valueOf(each.attributeValue("covered"));
            double coverage = MathUtils.divide((int)covered, (int)(covered + missed));
            row.setValue(str.toLowerCase() + "Total", (Object)((long)missed + (long)covered));
            row.setValue(str.toLowerCase() + "Covered", (Object)covered);
            row.setValue(str.toLowerCase() + "Coverage", (Object)coverage);
        }
    }

    public static void parseStatsReport(Document doc, DataReport statsReport) {
        Element root = doc.getRootElement();
        DataRow row = statsReport.isEmpty() ? statsReport.addRow() : statsReport.getRow(0);
        JacocoParser.parseCoverages(root, row);
    }

    public static void parseGroupsReport(Document doc, DataReport groupReport) {
        Element root = doc.getRootElement();
        List nodes = root.selectNodes("./group");
        for (Element each : nodes) {
            DataRow row = groupReport.addRow();
            row.setValue("groupName", (Object)each.attributeValue("name"));
            JacocoParser.parseCoverages(each, row);
        }
    }

    public static void parsePackagesReport(Document doc, DataReport packageReport) {
        Element root = doc.getRootElement();
        List nodes = root.selectNodes(".//package");
        for (Element each : nodes) {
            DataRow row = packageReport.addRow();
            row.setValue("groupName", (Object)"default");
            String packageName = each.attributeValue("name");
            packageName = packageName.replace("/", ".");
            row.setValue("packageName", (Object)packageName);
            JacocoParser.parseCoverages(each, row);
        }
    }

    public static void parseClassesReport(Document doc, DataReport classesReport) {
        Element root = doc.getRootElement();
        List nodes = root.selectNodes(".//class");
        Map classFileMap = (Map)GeneratorContext.getContext().get("CLASS_FILE_MAP");
        if (classFileMap == null) {
            classFileMap = Maps.newHashMap();
            GeneratorContext.getContext().put("CLASS_FILE_MAP", (Object)classFileMap);
        }
        for (Element each : nodes) {
            DataRow row = classesReport.addRow();
            row.setValue("groupName", (Object)"default");
            String packageName = each.valueOf("../@name");
            packageName = JavaNames.INSTANCE.getPackageName(packageName);
            row.setValue("packageName", (Object)packageName);
            String className = each.attributeValue("name");
            String actualClassName = JavaNames.INSTANCE.getClassName(className);
            row.setValue("className", (Object)actualClassName);
            int dollarPos = className.lastIndexOf(36);
            if (dollarPos > 0) {
                className = className.substring(0, dollarPos);
            }
            String fileName = className + ".java";
            String file = JacocoParser.findFile(fileName);
            row.setValue("fileName", (Object)file);
            classFileMap.put(packageName + "." + actualClassName, file);
            JacocoParser.parseCoverages(each, row);
        }
    }

    private static JacocoLine parseLine(Element node) {
        JacocoLine line = new JacocoLine();
        int nr = Integer.valueOf(node.attributeValue("nr"));
        int mi = Integer.valueOf(node.attributeValue("mi"));
        int ci = Integer.valueOf(node.attributeValue("ci"));
        int mb = Integer.valueOf(node.attributeValue("mb"));
        int cb = Integer.valueOf(node.attributeValue("cb"));
        line.setStartLine(nr);
        line.setEndLine(nr);
        line.setInstructionsTotal(mi + ci);
        line.setInstructionsCovered(ci);
        line.setBranchesTotal(mb + cb);
        line.setBranchesCovered(cb);
        return line;
    }

    public static void parseFilesReport(Document doc, DataReport filesReport) {
        Element root = doc.getRootElement();
        List nodes = root.selectNodes(".//sourcefile");
        for (Element each : nodes) {
            DataRow row = filesReport.addRow();
            row.setValue("groupName", (Object)"default");
            String packageName = each.valueOf("../@name");
            row.setValue("packageName", (Object)JavaNames.INSTANCE.getPackageName(packageName));
            String fileName = each.attributeValue("name");
            String file = JacocoParser.findFile(fileName);
            row.setValue("fileName", (Object)file);
            JacocoParser.parseCoverages(each, row);
            List lineNodes = each.selectNodes("./line");
            ArrayList lines = Lists.newArrayList();
            for (Element line : lineNodes) {
                lines.add(JacocoParser.parseLine(line));
            }
            row.setValue("lines", (Object)lines);
            List committers = ReportUtils.getCommitters((Build)Context.getBuild(), (String)fileName, (boolean)false);
            row.setValue("committers", (Object)committers);
        }
    }

    public static void parseMethodsReport(Document doc, DataReport methodsReport) {
        Element root = doc.getRootElement();
        List nodes = root.selectNodes(".//method");
        Map classFileMap = (Map)GeneratorContext.getContext().get("CLASS_FILE_MAP");
        if (classFileMap == null) {
            classFileMap = Maps.newHashMapWithExpectedSize((int)1);
        }
        for (Element each : nodes) {
            DataRow row = methodsReport.addRow();
            row.setValue("groupName", (Object)"default");
            String packageName = each.valueOf("../../@name");
            String className = each.valueOf("../@name");
            packageName = JavaNames.INSTANCE.getPackageName(packageName);
            row.setValue("packageName", (Object)packageName);
            String actualClassName = JavaNames.INSTANCE.getClassName(className);
            row.setValue("className", (Object)actualClassName);
            String fileName = (String)classFileMap.get(packageName + "." + actualClassName);
            row.setValue("fileName", (Object)fileName);
            String methodName = each.attributeValue("name");
            String desc = each.attributeValue("desc");
            String signature = each.attributeValue("signature");
            int firstLine = 0;
            try {
                firstLine = Integer.valueOf(each.attributeValue("line"));
            }
            catch (NumberFormatException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            row.setValue("methodName", (Object)JavaNames.INSTANCE.getMethodName(className, methodName, desc, signature));
            row.setValue("firstLine", (Object)firstLine);
            JacocoParser.parseCoverages(each, row);
        }
    }

    public static String findFile(String relativePath) {
        Set sources = (Set)GeneratorContext.getContext().get("JACOCO_JAVA_SOURCE_PATHS");
        for (String each : sources) {
            if (!each.endsWith(relativePath)) continue;
            return each;
        }
        return null;
    }
}

