/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.jacoco.parser.JacocoParser;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.dom4j.Document;

public abstract class AbstractJacocoProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;
    final ReportType type;

    protected AbstractJacocoProcessor(ReportCategory category, ReportType type) {
        super(category);
        this.type = type;
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void processResource(GeneratorResource resource) {
        File file = resource.getFile();
        Preconditions.checkState((file != null && file.exists() ? 1 : 0) != 0);
        Document doc = XMLHelper.readXML((File)file);
        this.onAfterLoadXML(doc);
        DataReport destReport = GeneratorContext.getContext().getDestReport();
        switch (this.type) {
            case GROUP: {
                JacocoParser.parseGroupsReport(doc, destReport);
                break;
            }
            case PACKAGE: {
                JacocoParser.parsePackagesReport(doc, destReport);
                break;
            }
            case CLASS: {
                JacocoParser.parseClassesReport(doc, destReport);
                break;
            }
            case FILE: {
                JacocoParser.parseFilesReport(doc, destReport);
                break;
            }
            case METHOD: {
                JacocoParser.parseMethodsReport(doc, destReport);
            }
        }
    }

    protected void onAfterLoadXML(Document doc) {
        GeneratorContext ctx = GeneratorContext.getContext();
        String oldName = ctx.getReportSet();
        String newName = doc.getRootElement().attributeValue("name");
        if (ctx.isReportsetEmpty() && !Strings.isNullOrEmpty((String)newName) && !newName.equalsIgnoreCase(oldName)) {
            ctx.setReportSet(newName);
            File oldWorkingDir = ctx.getWorkingDir();
            File newWorkingDir = new File(oldWorkingDir.getParentFile(), newName);
            try {
                FileUtils.moveDirectory((File)oldWorkingDir, (File)newWorkingDir);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ctx.setWorkingDir(newWorkingDir);
        }
    }

    static enum ReportType {
        GROUP,
        PACKAGE,
        CLASS,
        FILE,
        METHOD;

    }
}

