/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoPlugin;
import com.pmease.quickbuild.plugin.report.jacoco.parser.CounterType;

@Editable(name="JaCoCo Report")
public class JacocoAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(JacocoPlugin.class);
    }

    static void updateRow(DataRow row) {
        for (CounterType type : CounterType.values()) {
            double coverage = MathUtils.divide((Number)row.getLong(type.name().toLowerCase() + "Covered"), (Number)row.getLong(type.name().toLowerCase() + "Total"));
            row.setValue(type.name().toLowerCase() + "Coverage", (Object)coverage);
        }
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        JacocoAggregator.updateRow(destRow);
    }

    protected void updateStatsRow(DataRow row) {
        super.updateStatsRow(row);
        JacocoAggregator.updateRow(row);
    }

    protected String[] getAggregateColumns() {
        return new String[]{"instructionTotal", "instructionCovered", "branchTotal", "branchCovered", "lineTotal", "lineCovered", "complexityTotal", "complexityCovered", "methodTotal", "methodCovered", "classTotal", "classCovered"};
    }
}

