/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoPlugin;
import com.pmease.quickbuild.plugin.report.jacoco.parser.CounterType;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

@Editable(category={"Publish"}, name="JaCoCo Report", description="Publish JaCoCo original XML reports")
@ScriptApi(value="This step publishes the original Jacoco XML files.")
public class JacocoPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    public static final String JAVA_SOURCE_PATHS = "JACOCO_JAVA_SOURCE_PATHS";
    static final IOFileFilter GIT_AWARE_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)".git")));
    static final IOFileFilter HG_AWARE_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)".hg")));
    static final IOFileFilter JAVA_FILE_FILTER = FileFilterUtils.andFileFilter((IOFileFilter)FileFileFilter.FILE, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".java"));
    @XStreamOmitField
    private double instructionCoverage;
    @XStreamOmitField
    private double branchCoverage;
    @XStreamOmitField
    private double lineCoverage;
    @XStreamOmitField
    private double complexityCoverage;
    @XStreamOmitField
    private double methodCoverage;
    @XStreamOmitField
    private double classCoverage;
    private String sourcePath;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(JacocoPlugin.class);
    }

    public void onBeforePublish() {
        super.onBeforePublish();
        File workspaceDir = Context.getConfiguration().getWorkspaceDir().getAbsoluteFile();
        String str = this.getSourcePath();
        String[] paths = new String[]{};
        if (!Strings.isNullOrEmpty((String)str)) {
            paths = (String[])Iterables.toArray((Iterable)Splitter.on((String)"\n").trimResults().omitEmptyStrings().split((CharSequence)str), String.class);
        }
        HashSet set = Sets.newHashSet();
        if (paths.length > 0) {
            for (String each : paths) {
                File file = FileUtils.resolvePath((File)workspaceDir, (String)each);
                if (file == null || !file.exists()) {
                    Context.getLogger().warn("Source path " + each + " doesn't exist");
                    continue;
                }
                set.addAll(this.getAllFilePaths(workspaceDir, (Set<File>)ImmutableSet.of((Object)file)));
            }
        } else {
            set.addAll(this.getAllFilePaths(workspaceDir, (Set<File>)ImmutableSet.of((Object)workspaceDir)));
        }
        GeneratorContext.getContext().put(JAVA_SOURCE_PATHS, (Object)set);
    }

    private Set<String> getAllFilePaths(File workspaceDir, Set<File> sourceDirs) {
        Stopwatch watch = new Stopwatch().start();
        HashSet sources = Sets.newHashSet();
        for (File each : sourceDirs) {
            sources.addAll(this.getFilePaths(workspaceDir, each));
        }
        Context.getLogger().debug("Listing java files under directory [" + sourceDirs + "], cost " + watch.elapsed(TimeUnit.MILLISECONDS) + " milliseconds, total [" + sources.size() + "]");
        return sources;
    }

    private Set<String> getFilePaths(File workspaceDir, File sourceDir) {
        Collection files = FileUtils.listFiles((File)sourceDir, (IOFileFilter)JAVA_FILE_FILTER, (IOFileFilter)new AndFileFilter((List)ImmutableList.of((Object)GIT_AWARE_FILTER, (Object)HG_AWARE_FILTER, (Object)FileFilterUtils.makeSVNAware(null))));
        HashSet set = Sets.newHashSet();
        for (File each : files) {
            set.add(ReportUtils.getRelativePath((String)each.getAbsolutePath(), (String)workspaceDir.getAbsolutePath()));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "JacocoPublisher::saveStatsReport");
            Map map = category.getDefaultStats(db, "packages", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(map);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            this.instructionCoverage = JacocoPublisher.coverageOf(map, CounterType.INSTRUCTION);
            this.branchCoverage = JacocoPublisher.coverageOf(map, CounterType.BRANCH);
            this.classCoverage = JacocoPublisher.coverageOf(map, CounterType.CLASS);
            this.complexityCoverage = JacocoPublisher.coverageOf(map, CounterType.COMPLEXITY);
            this.lineCoverage = JacocoPublisher.coverageOf(map, CounterType.LINE);
            this.methodCoverage = JacocoPublisher.coverageOf(map, CounterType.METHOD);
            row.setValue("instructionCoverage", (Object)this.instructionCoverage);
            row.setValue("branchCoverage", (Object)this.branchCoverage);
            row.setValue("classCoverage", (Object)this.classCoverage);
            row.setValue("complexityCoverage", (Object)this.complexityCoverage);
            row.setValue("lineCoverage", (Object)this.lineCoverage);
            row.setValue("methodCoverage", (Object)this.methodCoverage);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byPackageUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_package", (String)reportsetName)).build();
    }

    static double coverageOf(Map<String, Object> map, CounterType type) {
        return MathUtils.divide((int)MapUtils.getIntValue(map, (Object)(type.name().toLowerCase() + "Covered"), (int)0), (int)MapUtils.getIntValue(map, (Object)(type.name().toLowerCase() + "Total"), (int)0));
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return JacocoChecksum.class;
    }

    protected String getStatsReportName() {
        return "stats";
    }

    @ScriptApi(value="Returns instruction coverage")
    public double getInstructionCoverage() {
        return this.instructionCoverage;
    }

    public void setInstructionCoverage(double instructionCoverage) {
        this.instructionCoverage = instructionCoverage;
    }

    @ScriptApi(value="Returns branch coverage")
    public double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBranchCoverage(double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    @ScriptApi(value="Returns line coverage")
    public double getLineCoverage() {
        return this.lineCoverage;
    }

    public void setLineCoverage(double lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    @ScriptApi(value="Returns complexity coverage")
    public double getComplexityCoverage() {
        return this.complexityCoverage;
    }

    public void setComplexityCoverage(double complexityCoverage) {
        this.complexityCoverage = complexityCoverage;
    }

    @ScriptApi(value="Returns method coverage")
    public double getMethodCoverage() {
        return this.methodCoverage;
    }

    public void setMethodCoverage(double methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    @ScriptApi(value="Returns class coverage")
    public double getClassCoverage() {
        return this.classCoverage;
    }

    public void setClassCoverage(double classCoverage) {
        this.classCoverage = classCoverage;
    }

    @Editable(name="Source Code Directory", description="Optional specify your source code directory to speed up the publishing")
    @Scriptable
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public static class JacocoChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(JacocoPlugin.class);
        }
    }
}

