/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageLevel;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import javax.validation.constraints.NotNull;

@Editable(name="JaCoCo Setting", category={"Report Settings"}, description="Define the JaCoCo report coverage threshold and color.")
public class JacocoPluginSetting {
    CoverageLevel levelHigh = new CoverageLevel("HIGH", 0.9, "#008C00");
    CoverageLevel levelMedium = new CoverageLevel("MEDIUM", 0.75, "#999966");
    CoverageLevel levelNormal = new CoverageLevel("NORMAL", 0.5, "#FF7400");
    CoverageLevel levelLow = new CoverageLevel("LOW", 0.0, "#FF1A00");

    public static JacocoPluginSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (JacocoPluginSetting)PluginSettingHelper.findConfigurationSetting(JacocoPlugin.class, (Configuration)configuration, (boolean)true);
    }

    public static JacocoPluginSetting get() {
        return JacocoPluginSetting.get(Context.getConfiguration());
    }

    public static String getColor(double coverage) {
        JacocoPluginSetting setting = JacocoPluginSetting.get();
        if (setting == null) {
            return ReportUtils.getCoverageColor((Number)coverage);
        }
        return setting.getCoverageColor(coverage);
    }

    public String getCoverageColor(double coverage) {
        if (coverage >= this.levelHigh.getThreshold()) {
            return this.levelHigh.getColor();
        }
        if (coverage >= this.levelMedium.getThreshold()) {
            return this.levelMedium.getColor();
        }
        if (coverage >= this.levelNormal.getThreshold()) {
            return this.levelNormal.getColor();
        }
        return this.levelLow.getColor();
    }

    @Editable(name="Coverage High", order=100)
    @NotNull
    public CoverageLevel getLevelHigh() {
        return this.levelHigh;
    }

    public void setLevelHigh(CoverageLevel levelHigh) {
        this.levelHigh = levelHigh;
    }

    @Editable(name="Coverage Medium", order=200)
    @NotNull
    public CoverageLevel getLevelMedium() {
        return this.levelMedium;
    }

    public void setLevelMedium(CoverageLevel levelMedium) {
        this.levelMedium = levelMedium;
    }

    @Editable(name="Coverage Normal", order=300)
    @NotNull
    public CoverageLevel getLevelNormal() {
        return this.levelNormal;
    }

    public void setLevelNormal(CoverageLevel levelNormal) {
        this.levelNormal = levelNormal;
    }

    @Editable(name="Coverage Low", order=400)
    @NotNull
    public CoverageLevel getLevelLow() {
        return this.levelLow;
    }

    public void setLevelLow(CoverageLevel levelLow) {
        this.levelLow = levelLow;
    }
}

