/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jacoco;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.datatype.BlockType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.plugin.report.jacoco.JacocoLine;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.source.Block;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class JacocoLineType
extends BlockType {
    private static final long serialVersionUID = 1L;

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        try {
            String[] tokens = new CSVParser(':').parse(str);
            JacocoLine block = this.getDefaultValue();
            block.setStartLine(Integer.valueOf(tokens[0]));
            block.setEndLine(Integer.valueOf(tokens[1]));
            block.setColor(tokens[2]);
            block.setMessage(tokens[3]);
            block.setInstructionsTotal(Integer.valueOf(tokens[4]));
            block.setInstructionsCovered(Integer.valueOf(tokens[5]));
            block.setBranchesTotal(Integer.valueOf(tokens[6]));
            block.setBranchesCovered(Integer.valueOf(tokens[7]));
            return block;
        }
        catch (Exception e) {
            throw new TypeCastException((Object)str, (DataType)this);
        }
    }

    public String asString(Object value, String pattern, Locale locale) {
        Block block = this.typeCast(value);
        if (block == null) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)block);
        }
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)sw, ':');
        try {
            ArrayList<String> str = new ArrayList<String>();
            str.add(String.valueOf(block.getStartLine()));
            str.add(String.valueOf(block.getEndLine()));
            if (block.getColor() == null) {
                str.add("");
            } else {
                str.add(block.getColor());
            }
            if (block.getMessage() == null) {
                str.add("");
            } else {
                str.add(block.getMessage());
            }
            if (block instanceof JacocoLine) {
                JacocoLine line = (JacocoLine)block;
                str.add(String.valueOf(line.getInstructionsTotal()));
                str.add(String.valueOf(line.getInstructionsCovered()));
                str.add(String.valueOf(line.getBranchesTotal()));
                str.add(String.valueOf(line.getBranchesCovered()));
            }
            writer.join(str);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)sw);
        }
    }

    protected String getWriteFormat() {
        return "XML";
    }

    public JacocoLine getDefaultValue() {
        return new JacocoLine();
    }
}

