/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.scm.mercurial.HgPluginSetting;
import com.pmease.quickbuild.repositorysupport.Revision;
import org.apache.commons.lang.StringUtils;

@ScriptApi(value="This class represents revision of a Mercurial repository.")
public class HgRevision
extends Revision {
    private static final long serialVersionUID = 1L;
    private String value;
    public static HgRevision NULLID = new HgRevision("0000000000000000000000000000000000000000");

    public HgRevision() {
    }

    public HgRevision(String rev) {
        this.value = StringUtils.isEmpty((String)rev) ? NULLID.getValue() : rev;
    }

    @ScriptApi(value="Get revision number based on remote repository. See http://mercurial.selenic.com/wiki/RevisionNumber for details.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static HgRevision parseRevision(String rev) {
        if (StringUtils.isEmpty((String)rev)) {
            return NULLID;
        }
        return new HgRevision(rev);
    }

    public String toShortId() {
        HgPluginSetting setting = HgPluginSetting.get();
        int length = setting.getIdLength();
        if (length == 0) {
            return this.toString();
        }
        return this.toString().substring(0, length);
    }
}

