/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.TooBigXMLLogException;
import com.pmease.quickbuild.plugin.scm.mercurial.HgCli;
import com.pmease.quickbuild.plugin.scm.mercurial.HgPluginSetting;
import com.pmease.quickbuild.plugin.scm.mercurial.HgProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRevision;
import com.pmease.quickbuild.plugin.scm.mercurial.HgSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.mercurial.HgUrl;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.repositorysupport.WorkingDirLocator;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Mercurial", description="Configure a Mercurial repository here. By default, QuickBuild executes \"hg\" to pull changes from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Mercurial plugin through the plugin management page.")
@ScriptApi
public class HgRepository
extends AbstractRepository<HgRevision> {
    private static final long serialVersionUID = 1L;
    private String pullUrl;
    private String pushUrl;
    private String userName;
    private String password;
    private String branch;
    private String destPath;
    private String buildRevision;
    @XStreamOmitField
    private Set<String> syncedNodes;
    private HgProofBuildSupport proofBuildSupport;
    @Transient
    private String repositoryId;
    public static final String PULL_URL = "pullurl";
    public static final String PUSH_URL = "pushurl";
    public static final String BRANCH = "branch";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DOT_HG = ".hg";

    protected void checkoutByRevision(HgRevision revision) {
        this.getHg().checkout(revision.toString());
        Commandline cmd = new Commandline().setExecutable(this.getHgPath()).addArgLine("log -r0 --template {node}");
        Context.getLogger().info("Retrieving repository id...");
        cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                HgRepository.this.repositoryId = line;
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
    }

    protected List<Changeset> getChangesBetween(HgRevision startRevision, HgRevision endRevision) {
        try {
            List<Changeset> changes = this.getHg().changesBetween(startRevision.toString(), endRevision.toString());
            Iterator<Changeset> it = changes.iterator();
            while (it.hasNext()) {
                Changeset c = it.next();
                if (!c.getId().equalsIgnoreCase(startRevision.toString())) continue;
                it.remove();
            }
            return changes;
        }
        catch (TooBigXMLLogException e) {
            Context.getLogger().warn("There are too many changes between " + (Object)((Object)startRevision) + " and " + (Object)((Object)endRevision) + ". Ignore calculating changes");
            return Collections.emptyList();
        }
    }

    protected HgRevision getHeadRevision() {
        HgCli hg = this.getHg();
        if (!StringUtils.isEmpty((String)this.getBuildRevision())) {
            return hg.revision(this.getBuildRevision());
        }
        return hg.revision(null);
    }

    public SourceViewSupport<HgRevision> getSourceViewSupport() {
        return new WorkingDirLocator((SourceViewSupport)new HgSourceViewSupport(this));
    }

    protected boolean isQuietSince(Date date) {
        return this.getHg().changesSince(date, new String[]{"-l1"}).isEmpty();
    }

    protected void labelOnRevision(HgRevision revision, String label, String comment) {
        this.getHg().tagRemote(revision.toString(), label, comment);
    }

    private String getActualUrl(String url, boolean descriptive) {
        HgUrl u = new HgUrl(url, this.getUserName(), this.getPassword());
        if (descriptive) {
            return u.toDescriptiveString();
        }
        return u.toString();
    }

    public String getActualPullUrl(boolean descriptive) {
        return this.getActualUrl(this.getPullUrl(), descriptive);
    }

    public String getActualPushUrl(boolean descriptive) {
        String push = this.getPushUrl();
        if (StringUtils.isEmpty((String)push)) {
            return this.getActualPullUrl(descriptive);
        }
        return this.getActualUrl(push, descriptive);
    }

    @Editable(order=1000, name="Pull URL", description="Specify URL of a mercurial repository to pull changes from, for example:<em>http://scm-host:8000/myproject</em>")
    @NotEmpty
    @ScriptApi(value="Get URL of the repository to pull changes from.")
    @Scriptable
    public String getPullUrl() {
        return this.pullUrl;
    }

    public void setPullUrl(String pullUrl) {
        this.pullUrl = pullUrl;
    }

    @Editable(order=1100, name="Push URL", description="Optionally specify the push url to push tags to remote repository. If blank, the pull url is used.")
    @ScriptApi(value="Get URL of the repository to push tags.")
    @Scriptable
    public String getPushUrl() {
        return this.pushUrl;
    }

    public void setPushUrl(String pushUrl) {
        this.pushUrl = pushUrl;
    }

    @Editable(order=1200, name="User name", description="Optionally specify the user who has permission to access the above url.")
    @ScriptApi(value="Get the user name used to login the remote repository.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=1300, description="Specify password of the above user.<br><span class='bold red'>IMPORTANT:</span> For SSH based protocols (ssh, scp, sftp), please do NOT specify password here. You need to use public key authentication without pass phrase instead to avoid hanging. Refer to http://wiki.pmease.com for details.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=1400, name="Destination Path", description="Specify the destination path to which contents in the above url will be retrieved into. This path is relative to the running configuration's workspace. If left empty, the workspace directory itself will be used to put checked out contents.")
    @ScriptApi(value="Get destination path to put checked out files. Null if workspace directory is used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=1700, name="Branch name", description="Optionally specify the branch which you want to pull. If not specified, the 'default' branch will be used.")
    @ScriptApi(value="Get specified branch to build against.")
    @Scriptable
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getActualBranch() {
        String b = this.getBranch();
        if (StringUtils.isEmpty((String)b)) {
            return "default";
        }
        return b;
    }

    @Editable(order=1800, name="Changeset or Tag to Build", description="Optionally specify the change set or tag to build against. If specified, the branch property will be ignored; otherwise, tip revision of the above branch will be checked out.")
    @ScriptApi(value="Get specified revision to build against. Null if build against head revision.")
    @Scriptable
    public String getBuildRevision() {
        return this.buildRevision;
    }

    public void setBuildRevision(String buildRevision) {
        this.buildRevision = buildRevision;
    }

    public Properties getCurrentRC() {
        Properties map = new Properties();
        map.put(PULL_URL, this.getActualPullUrl(false));
        map.put(PUSH_URL, this.getActualPushUrl(false));
        return map;
    }

    public File dotHg() {
        return new File(this.getWorkingDir(), DOT_HG);
    }

    public boolean exists() {
        return this.getWorkingDir().exists() && this.dotHg().exists();
    }

    public HgCli getHg() {
        HgCli hgCli = new HgCli(this);
        String nodeAddress = Grid.instance.getLocalNode().getAddress();
        if (!this.getSyncedNodes().contains(nodeAddress) || !new File(this.getWorkingDir(), DOT_HG).exists()) {
            hgCli.sync();
            this.getSyncedNodes().add(nodeAddress);
        }
        return hgCli;
    }

    private Set<String> getSyncedNodes() {
        if (this.syncedNodes == null) {
            this.syncedNodes = new HashSet<String>();
        }
        return this.syncedNodes;
    }

    @Editable(order=700, description="Check this to enable proof build for this repository.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public HgProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(HgProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    String getHgPath() {
        HgPluginSetting setting = HgPluginSetting.get();
        String path = setting.getHgExePath();
        if (StringUtils.isEmpty((String)path)) {
            return "hg";
        }
        return path;
    }

    String getRepositoryId() {
        return this.repositoryId;
    }

    public String format(String type, Map<String, Object> map) {
        AbstractRepository.FormatType t = AbstractRepository.FormatType.valueOf((String)type);
        switch (t) {
            case CHANGEID: {
                return this.formatId(map);
            }
            case EDITION: {
                return this.formatEdition(map);
            }
        }
        throw new IllegalArgumentException("Unknown format field type " + type);
    }

    String formatId(Map<String, Object> map) {
        String revno = (String)map.get("additional");
        String hash = (String)map.get("changeId");
        hash = new HgRevision(hash).toShortId();
        if (StringUtils.isEmpty((String)revno)) {
            return hash;
        }
        return revno + ":" + hash;
    }

    String formatEdition(Map<String, Object> map) {
        String edition = (String)map.get("edition");
        if (edition == null || edition.length() < 40) {
            return edition;
        }
        return new HgRevision(edition).toShortId();
    }
}

