/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.scm.helper.ini.IniFile;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRepository;
import java.io.File;

public class HgRc
extends IniFile {
    private final HgRepository repository;
    private static String FILE_NAME = "hgrc";

    public HgRc(HgRepository repository) {
        this.repository = repository;
        this.load();
    }

    public void updatePaths() {
        this.setProperty("paths", "default", this.repository.getPullUrl());
        if (Strings.isNullOrEmpty((String)this.repository.getPushUrl())) {
            this.setProperty("paths", "default-push", this.repository.getPullUrl());
        } else {
            this.setProperty("paths", "default-push", this.repository.getPushUrl());
        }
        this.setProperty("auth", "default.prefix", "*");
        if (!Strings.isNullOrEmpty((String)this.repository.getUserName())) {
            this.setProperty("auth", "default.username", this.repository.getUserName());
        }
        if (!Strings.isNullOrEmpty((String)this.repository.getPassword())) {
            this.setProperty("auth", "default.password", this.repository.getPassword());
        }
    }

    public void load() {
        this.load(this.getFile());
    }

    public void save() {
        this.save(this.getFile());
    }

    public File getFile() {
        return new File(this.repository.dotHg(), FILE_NAME);
    }
}

