/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.mercurial.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRepository;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

public class HgProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private static final long serialVersionUID = 1L;
    private HgRepository repository;
    private String localPath;
    private String changesetNumber;
    private String mergeCondition = "true";
    private String pushCondition = "build.successful";

    public HgProofBuildSupport(HgRepository repository) {
        this.repository = repository;
    }

    @Editable(name="Local Repository Path", order=100, description="Specify path to your local Mercurial repository. QuickBuild will send outgoing changes found in this repository to run proof build.<br><span class='bold red'>IMPORTANT:</span> Default pull and push destination of this local repository should point to the remote repository defined above, and the pull/push operation should not prompt for any user name or password.")
    @Scriptable
    @ScriptApi(value="Get path to local mercurial repository. Will not be null.")
    @NotEmpty
    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Editable(name="Change Set Number", order=200, description="Optionally specify an outgoing change set number or revision for proof build. All ancestor change sets of specified change set will also be verified. If left empty, all outgoing change sets will be verified.")
    @ScriptApi(value="Get change set number for proof build. Null if not specified.")
    @Scriptable
    public String getChangesetNumber() {
        return this.changesetNumber;
    }

    public void setChangesetNumber(String changesetNumber) {
        this.changesetNumber = changesetNumber;
    }

    @Editable(name="Merge Condition", order=400, description="This condition only takes effect when change set number is not specified above, and can make proof build more accurate when dealing with pushed changes of other developers. If satisfied, QuickBuild will pull incoming changes from this repository to merge with the local repository before collecting outgoing change sets.")
    @Expressions(value={"always merge", "true", "do not merge", "false"})
    @ScriptApi(value="Get merge condition. Will not be null.")
    @Scriptable
    @NotEmpty
    public String getMergeCondition() {
        return this.mergeCondition;
    }

    public void setMergeCondition(String mergeCondition) {
        this.mergeCondition = mergeCondition;
    }

    @Editable(name="Push Condition", order=500, description="Specify the condition to push verified outgoing change sets. If this condition is satisfied, outgoing change sets specified above will be pushed to this repository after the build finishes.")
    @Expressions(value={"push only when build is successful", "build.successful", "always push", "true", "do not push", "false"})
    @Scriptable
    @ScriptApi(value="Get push condition. Will not be null.")
    @NotEmpty
    public String getPushCondition() {
        return this.pushCondition;
    }

    public void setPushCondition(String pushCondition) {
        this.pushCondition = pushCondition;
    }

    @ScriptApi(value="Get repository object.")
    public HgRepository getRepository() {
        return this.repository;
    }

    public void buildFinished() {
        ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        if (((Boolean)scriptEngine.evaluate(this.getPushCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
            if (this.getChangesetNumber() != null) {
                Context.getLogger().info("Pushing outgoing changes...");
                Commandline cmd = this.buildHgCmd().addArgLine("push -r").addArgValue(this.getChangesetNumber());
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                    public void consume(String line) {
                        if (line.contains("Not trusting file")) {
                            Context.getLogger().warn(line);
                        } else {
                            Context.getLogger().error(line);
                        }
                    }
                }).checkReturnCode();
            } else {
                Context.getLogger().info("No outgoing change sets to push.");
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return new File(this.repository.getWorkingDir(), repositoryPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocalChange getLocalChange(File changeStoreDir) {
        List<Changeset> changes;
        Commandline cmd = this.buildHgCmd().addArgLine("log -r0 --template {node}");
        Context.getLogger().info("Checking identifier of local repository...");
        final String[] id = new String[]{null};
        cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                id[0] = line;
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        if (!id[0].equals(this.repository.getRepositoryId())) {
            throw new ScmException("Specified local repository does not relate to the defined remote repository.");
        }
        cmd = this.buildHgCmd().addArgValue("branch");
        Context.getLogger().info("Checking branch of local repository...");
        final String[] branch = new String[]{null};
        cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                if (StringUtils.isNotBlank((String)line)) {
                    branch[0] = line;
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        if (!branch[0].equals(this.repository.getActualBranch())) {
            throw new ScmException("Local repository should work on branch '" + this.repository.getActualBranch() + "'.");
        }
        Commandline outgoingCmd = this.buildHgCmd().addArgValue("outgoing");
        if (this.getChangesetNumber() == null) {
            outgoingCmd.addArgValue("-b").addArgValue(this.repository.getActualBranch());
            ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
            if (((Boolean)scriptEngine.evaluate(this.getMergeCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
                cmd = this.buildHgCmd().addArgValue("summary");
                Context.getLogger().info("Checking if there are uncommitted files...");
                final boolean[] commitClean = new boolean[]{false};
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().info(line);
                        if (line.startsWith("commit:") && line.endsWith("(clean)")) {
                            commitClean[0] = true;
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                if (!commitClean[0]) {
                    throw new ScmException("QuickBuild can not proceed to merge with incoming change sets since there are uncommitted files in your working directory.");
                }
                cmd = this.buildHgCmd().addArgLine("pull -b").addArgValue(this.repository.getActualBranch());
                Context.getLogger().info("Pulling incoming change sets...");
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                    public void consume(String line) {
                        if (line.contains("Not trusting file")) {
                            Context.getLogger().warn(line);
                        } else {
                            Context.getLogger().error(line);
                        }
                    }
                }).checkReturnCode();
                Context.getLogger().info("Printing summary info of working directory...");
                final boolean[] needToMerge = new boolean[]{false};
                cmd = this.buildHgCmd().addArgLine("summary");
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().info(line);
                        if (line.startsWith("update:") && line.endsWith("(merge)")) {
                            needToMerge[0] = true;
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                if (needToMerge[0]) {
                    cmd = this.buildHgCmd().addArgLine("--config ui.merge=internal:merge").addArgLine("merge -y");
                    Context.getLogger().info("Merging change sets...");
                    final boolean[] conflictsFound = new boolean[]{false};
                    final boolean[] uncommittedChangesFound = new boolean[]{false};
                    Commandline.ExecuteResult result = cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            Context.getLogger().info(line);
                            if (line.startsWith("use 'hg resolve' to retry unresolved file merges")) {
                                conflictsFound[0] = true;
                            }
                        }
                    }, new LineConsumer(){

                        public void consume(String line) {
                            Context.getLogger().error(line);
                            if (line.startsWith("abort: outstanding uncommitted changes")) {
                                uncommittedChangesFound[0] = true;
                            }
                        }
                    });
                    if (conflictsFound[0]) {
                        throw new ScmException("Merge conflicts found. Please resolve them and commit first, then run proof build again.");
                    }
                    if (result.getReturnCode() != 0) {
                        if (!uncommittedChangesFound[0]) throw result.buildException();
                        throw new ScmException("Can not merge as there are uncommitted changes in the working directory.");
                    }
                    cmd = this.buildHgCmd().addArgLine("commit -m").addArgValue("merged with incoming change sets by QuickBuild.");
                    Context.getLogger().info("Committing merge results...");
                    cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                }
            }
        } else {
            outgoingCmd.addArgValue("-r").addArgValue(this.getChangesetNumber());
        }
        outgoingCmd.addArgLine("--style xml -v");
        Context.getLogger().info("Checking outgoing change sets...");
        final ChangeLogConsumer consumer = new ChangeLogConsumer();
        final boolean[] noChangesFound = new boolean[]{false};
        final boolean[] xmlStarted = new boolean[]{false};
        Commandline.ExecuteResult result = outgoingCmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer("UTF-8"){

            public void consume(String line) {
                Context.getLogger().info(line);
                if (!line.contains("Not trusting file")) {
                    if (line.startsWith("no changes found")) {
                        noChangesFound[0] = true;
                    }
                    if (line.startsWith("<?xml version")) {
                        if (!xmlStarted[0]) {
                            consumer.getLines().add("<log>");
                        }
                        xmlStarted[0] = true;
                    }
                    if (xmlStarted[0] && !line.startsWith("<?xml version") && !line.startsWith("<log>")) {
                        consumer.getLines().add(line);
                    }
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger());
        if (result.getReturnCode() != 0) {
            if (!noChangesFound[0]) throw result.buildException();
            changes = new ArrayList<Changeset>();
        } else {
            changes = consumer.getChanges();
        }
        ArrayList mergedModifications = new ArrayList();
        for (Changeset each : changes) {
            Modification.merge(mergedModifications, (List)each.getModifications());
            this.setChangesetNumber(each.getId());
        }
        LocalChange localChange = new LocalChange();
        for (Modification each : mergedModifications) {
            if (each.getAction() == Modification.Action.DELETE) {
                localChange.getDeletePaths().add(each.getPath());
                continue;
            }
            if (each.getAction() == Modification.Action.ADD) {
                localChange.getAddPaths().add(each.getPath());
            } else {
                localChange.getModifyPaths().add(each.getPath());
            }
            File destFile = new File(changeStoreDir, each.getPath());
            FileUtils.createDir((File)destFile.getParentFile());
            cmd = this.buildHgCmd().addArgLine("cat -r").addArgValue(each.getEdition()).addArgValue("-o").addArgValue(destFile.getAbsolutePath()).addArgValue(each.getPath());
            Context.getLogger().debug("Reading content of path: " + each.getPath());
            cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        }
        return localChange;
    }

    private File getWorkingDir() {
        return new File(this.getLocalPath());
    }

    private Commandline buildHgCmd() {
        return new Commandline().setExecutable(this.repository.getHgPath());
    }
}

