/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.mercurial.HgPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.util.Stack;
import org.dom4j.Element;

@ScriptApi
public class HgPluginSetting {
    private String hgExePath;
    private int idLength = 10;

    @Editable(order=100, name="Hg Executable Path", description="Specify path to hg executable. For example: <b>/usr/local/bin/hg</b>")
    @ScriptApi(value="Get path to hg executable. Null if not specified.")
    @Scriptable
    public String getHgExePath() {
        return this.hgExePath;
    }

    public void setHgExePath(String hgExePath) {
        this.hgExePath = hgExePath;
    }

    @Editable(order=200, name="Revision Id Length", description="Specify the length of revision id.")
    @ScriptApi(value="Get the length of revision id")
    @Scriptable
    public int getIdLength() {
        return this.idLength;
    }

    public void setIdLength(int idLength) {
        this.idLength = idLength;
    }

    public static HgPluginSetting get() {
        return (HgPluginSetting)PluginSettingHelper.getSetting(HgPlugin.class, (boolean)true);
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        root.addElement("idLength").setText("10");
    }
}

