/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCli;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.plugin.scm.mercurial.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.mercurial.HgCommand;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRc;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRepository;
import com.pmease.quickbuild.plugin.scm.mercurial.HgRevision;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class HgCli
extends ScmCli<HgCli, HgRepository, HgCommand> {
    private static final DateTimeFormatter RFC3339_FMT = ISODateTimeFormat.dateTimeNoMillis();

    public HgCli(HgRepository repository) {
        super((AbstractRepository)repository, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private HgCli anothersync() {
        boolean b;
        File workingDir = this.getWorkingDir();
        this.getLogger().debug("sync working directory [" + workingDir + "]...");
        Map changedSettings = this.getRepository().getChangedSettings();
        boolean bl = b = !changedSettings.isEmpty();
        if (!changedSettings.isEmpty()) {
            this.getLogger().info("Repository setting changed, deleting working directory [" + workingDir + "]");
            FileUtils.deleteDir((File)workingDir);
        }
        try {
            String oldValue;
            this.doSync();
            if (changedSettings.containsKey("branch") && !StringUtils.isEmpty((String)(oldValue = ((AbstractRepository.Property)changedSettings.get("branch")).getOldValue()))) {
                this.pull();
            }
            HgCli hgCli = this;
            return hgCli;
        }
        finally {
            if (b) {
                this.getRepository().saveRC();
            }
        }
    }

    public HgRepository getRepository() {
        return (HgRepository)super.getRepository();
    }

    protected void doSync() {
        if (this.getRepository().exists()) {
            this.pull();
        } else {
            this.create();
        }
    }

    public HgCli create() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating mercurial repository in directory: " + this.getWorkingDir());
        }
        return this.clone().updateHgRc();
    }

    public HgCli clone() {
        File workingDir = this.getWorkingDir();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Cloning mercurial repository to directory: " + workingDir);
        }
        FileUtils.createDir((File)workingDir);
        HgCommand cmd = (HgCommand)this.buildCommand("clone", ((HgRepository)this.repository).getActualPullUrl(false));
        cmd.setValue(workingDir.getAbsolutePath());
        return (HgCli)this.run(cmd, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public HgCli updateHgRc() {
        FileUtils.createDir((File)this.getRepository().dotHg());
        HgRc rc = new HgRc(this.getRepository());
        rc.updatePaths();
        rc.save();
        return this;
    }

    public HgCli pull() {
        return (HgCli)this.run("pull -f", (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
    }

    public HgCli checkout(String revspec) {
        String rev = StringUtils.isEmpty((String)revspec) ? "tip" : revspec;
        return (HgCli)this.run(this.buildCommand("update -r", rev), (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
    }

    public HgCli push() {
        return (HgCli)this.run(this.buildCommand("push -b", this.getRepository().getActualBranch()), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public HgRevision revision(String revspec) {
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        HgCommand command = (HgCommand)this.buildCommand("log -l1 --template=\"{node}\n\"");
        if (!StringUtils.isEmpty((String)revspec)) {
            command.addParameter("-r", revspec);
        } else {
            command.addParameter("-b", this.getRepository().getActualBranch());
        }
        this.run(command, (LineConsumer)consumer);
        String line = consumer.lastLine().trim();
        if (StringUtils.isEmpty((String)line)) {
            String rev = StringUtils.isEmpty((String)revspec) ? "tip" : revspec;
            throw new ScmException("Detect mercurial revision '" + rev + "' failed on branch '" + this.getRepository().getActualBranch() + "'. Does this revision exist in another branch?");
        }
        return new HgRevision(line);
    }

    public HgCli tagLocal(String revspec, String label, String comment) {
        HgCommand command = (HgCommand)this.buildCommand("tag -f");
        String rev = StringUtils.isEmpty((String)revspec) ? "tip" : revspec;
        command.addParameter("-r", rev);
        String actualComment = StringUtils.isEmpty((String)comment) ? " " : comment;
        command.addParameter("-m", actualComment);
        command.setValue(label);
        return (HgCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public HgCli tagRemote(String revspec, String label, String comment) {
        return this.checkout(this.getRepository().getActualBranch()).tagLocal(revspec, label, comment).push().checkout(revspec);
    }

    private Date getDateOfRevision(String rev) {
        if (StringUtils.isEmpty((String)rev)) {
            return INVALID_DATE;
        }
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        HgCommand command = (HgCommand)this.buildCommand("log -l1 --template=\"{date|rfc3339date}\n\"");
        command.addParameter("-r", rev);
        this.run(command, (LineConsumer)consumer);
        String line = consumer.lastLine().trim();
        if (StringUtils.isEmpty((String)line)) {
            return INVALID_DATE;
        }
        return RFC3339_FMT.parseDateTime(line).toDate();
    }

    public List<Changeset> changesBetween(String from, String to) {
        this.getLogger().info("Getting changes between " + from + " - " + to);
        Date fromDate = this.getDateOfRevision(from);
        Date toDate = this.getDateOfRevision(to);
        if (fromDate.getTime() > toDate.getTime()) {
            this.getLogger().warn("The start revision [" + from + "] seems elder than end revision [" + to + "].");
        }
        ChangeLogConsumer consumer = new ChangeLogConsumer();
        HgCommand command = (HgCommand)this.buildCommand("log -v --style=xml");
        command.addParameter("-b", this.getRepository().getActualBranch());
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)from)) {
            sb.append(from);
        }
        sb.append(":");
        if (!StringUtils.isEmpty((String)to)) {
            sb.append(to);
        }
        command.addParameter("-r", sb.toString());
        this.run(command, (LineConsumer)consumer);
        return consumer.getChanges();
    }

    public List<Changeset> changesSince(Date date, String[] moreArgs) {
        ChangeLogConsumer consumer = new ChangeLogConsumer();
        HgCommand command = (HgCommand)this.buildCommand("log -v --style=xml");
        command.addParameter("-b", this.getRepository().getActualBranch());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        command.addParameter("-d", ">" + df.format(date));
        if (moreArgs != null) {
            for (String each : moreArgs) {
                command.setLine(each);
            }
        }
        this.run(command, (LineConsumer)consumer);
        return consumer.getChanges();
    }

    public List<String> show(String path, String revspec) {
        if (!this.getRepository().exists()) {
            this.getLogger().error("Failed to read file '" + path + "' due to local repository does not exist.");
            return null;
        }
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        HgCommand command = (HgCommand)this.buildCommand("cat ");
        command.addParameter("-r", StringUtils.isEmpty((String)revspec) ? "tip" : revspec);
        command.setValue(path);
        try {
            this.run(command, (LineConsumer)consumer);
        }
        catch (QuickbuildException e) {
            String msg = e.getMessage();
            if (msg != null && msg.toLowerCase().contains("no such file")) {
                return Collections.emptyList();
            }
            throw e;
        }
        return consumer.getLines();
    }

    protected HgCommand createCommand() {
        HgCommand cmd = (HgCommand)new HgCommand(this.getRepository()).addArgLine("-y");
        cmd.setSecretMasker(new SecretMasker(){

            public String mask(String message) {
                if (HgCli.this.getRepository().getPassword() != null) {
                    return StringUtils.replace((String)message, (String)(":" + HgCli.this.getRepository().getPassword() + "@"), (String)":******@");
                }
                return message;
            }
        });
        return cmd;
    }
}

