/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.mercurial;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.TooBigXMLLogException;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.plugin.scm.mercurial.HgChangeset;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ChangeLogConsumer
extends LineListConsumer {
    private static final DateTimeFormatter ISO8601 = ISODateTimeFormat.dateTimeNoMillis();
    private static final String HGTAGS = ".hgtags";

    public ChangeLogConsumer() {
        super(Log.LogLevel.DEBUG, "UTF-8");
    }

    public List<Changeset> getChanges() {
        return ChangeLogConsumer.parse(this.getContent());
    }

    public static List<Changeset> parse(String xml) {
        if (xml.length() > 10000000) {
            throw new TooBigXMLLogException();
        }
        if (StringUtils.isBlank((String)xml)) {
            return Collections.emptyList();
        }
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            ArrayList<Changeset> changes = new ArrayList<Changeset>();
            List elements = doc.getRootElement().elements("logentry");
            HgChangeset previous = null;
            for (Element each : elements) {
                HgChangeset change = new HgChangeset();
                change.setUser(each.valueOf("./author"));
                DateTime dt = ISO8601.parseDateTime(each.valueOf("./date"));
                change.setDate(dt.toDate());
                change.setComment(each.valueOf("./msg"));
                String revision = each.valueOf("./@revision");
                String node = each.valueOf("./@node");
                change.setId(node);
                change.setRevno(Integer.valueOf(revision));
                List paths = each.selectNodes("./paths/path");
                ArrayList<Modification> modifications = new ArrayList<Modification>();
                boolean forTag = false;
                for (Element path : paths) {
                    String p = path.getTextTrim();
                    if (HGTAGS.equalsIgnoreCase(p)) {
                        forTag = true;
                        break;
                    }
                    Modification m = new Modification();
                    String a = path.valueOf("./@action");
                    Modification.Action action = ChangeLogConsumer.getAction(a.charAt(0));
                    if (action == null) continue;
                    m.setAction(action);
                    m.setPath(p);
                    m.setEdition(node);
                    if (previous != null) {
                        m.setPreviousEdition(previous.getId());
                    }
                    modifications.add(m);
                }
                change.setModifications(modifications);
                if (!forTag) {
                    changes.add(change);
                }
                previous = change;
            }
            return changes;
        }
        catch (DocumentException e) {
            throw new ScmException("Parsing mercurial change log failed!", (Throwable)e);
        }
    }

    static Modification.Action getAction(char a) {
        if (a == 'R') {
            return Modification.Action.DELETE;
        }
        if (a == 'M' || a == 'C') {
            return Modification.Action.MODIFY;
        }
        if (a == 'A') {
            return Modification.Action.ADD;
        }
        return null;
    }
}

