/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.redmine;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.plugin.tracker.redmine.RedmineCli;
import com.pmease.quickbuild.plugin.tracker.redmine.RedmineSetting;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class RedmineTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;

    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        LinkedHashMap issues = Maps.newLinkedHashMap();
        RedmineCli cli = RedmineCli.newInstance();
        for (String each : keys) {
            Issue issue = cli.getIssue(each);
            if (issue == null) continue;
            issues.put(each, issue);
        }
        return issues;
    }

    public String getIssueUrlPattern() {
        RedmineSetting setting = RedmineSetting.get();
        return StringHelper.normalizeUrl((String)setting.getHost()) + "/issues/$KEY";
    }

    public String extractIssueKey(String matched) {
        Long id = TrackerHelper.extractLong((String)matched);
        if (id == null) {
            return null;
        }
        return id.toString();
    }
}

