/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.redmine;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.redmine.RedminePlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Redmine Server", order=1050, category={"Issue Tracker"})
public class RedmineSetting
extends AbstractTrackerSetting {
    private static final long serialVersionUID = 1L;
    private String associatedProject;

    public RedmineSetting() {
        this.setIssuePattern("(?<!\\:)(?:#|bug:)\\d+");
    }

    public static RedmineSetting get() {
        return RedmineSetting.get(Context.getConfiguration());
    }

    public static RedmineSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (RedmineSetting)((Object)PluginSettingHelper.findConfigurationSetting(RedminePlugin.class, (Configuration)configuration, (boolean)true));
    }

    @Editable(order=1000, name="Associated Project Key", description="Specify key of the Redmine project this configuration corresponds to.")
    @Scriptable
    @NotEmpty
    @ScriptApi
    public String getAssociatedProject() {
        return this.associatedProject;
    }

    public void setAssociatedProject(String associatedProject) {
        this.associatedProject = associatedProject;
    }

    @Editable(order=200, name="Server Url", description="Define the Redmine server url. For example: http://redmine.example.com")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getHost() {
        return super.getHost();
    }

    @Editable(order=500, name="Issue Pattern", description="Specify <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> of Redmine issue keys in SCM commit message. This pattern will be used by QuickBuild to transform issue keys to links. The default pattern will recognize <i>#123</i> and <i>bug:123</i> as keys while won't recognize <i>:#123</i>.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getIssuePattern() {
        return super.getIssuePattern();
    }
}

