/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.redmine;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.format.ISODateTimeFormat;

public class RedmineHelper {
    static final String ID = "id";
    static final String PROJECT_ID = "project_id";
    static final String TRACKER_ID = "tracker_id";
    static final String STATUS_ID = "status_id";
    static final String PRIORITY_ID = "priority_id";
    static final String AUTHOR_ID = "author_id";
    static final String ASSIGNED_TO_ID = "assigned_to_id";
    static final String SUBJECT = "subject";
    static final String DESCRIPTION = "description";
    static final String FIX_VERSION_ID = "fix_version_id";
    static final String START_DATE = "start_date";
    static final String DUE_DATE = "due_date";
    static final String DONE_RATIO = "done_ratio";
    static final String ESTIMATED_HOURS = "estimated_hours";
    static final String SPENT_HOURS = "spent_hours";
    static final String CREATED_ON = "created_on";
    static final String UPDATED_ON = "updated_on";
    static final String CUSTOM_FIELD = "cf_";
    static final String TRACKER = "tracker";
    static final String PRIORITY = "priority";
    static final String STATUS = "status";
    static final String ASSIGNED_TO = "assigned_to";
    static final String AUTHOR = "author";
    static Set<String> SUPPORTED_FIELDS_OF_CREATE = ImmutableSet.of((Object)"id", (Object)"tracker_id", (Object)"status_id", (Object)"priority_id", (Object)"author_id", (Object)"assigned_to_id", (Object[])new String[]{"subject", "description", "fix_version_id", "start_date", "due_date", "done_ratio", "estimated_hours", "spent_hours", "created_on", "updated_on"});

    public static Issue parseIssue(String xml) {
        if (Strings.isNullOrEmpty((String)xml)) {
            return null;
        }
        Issue issue = new Issue();
        Document doc = XMLHelper.readXML((String)xml);
        Element root = doc.getRootElement();
        issue.setIssueKey(root.elementText(ID));
        issue.setSummary(root.elementText(SUBJECT));
        issue.setCreated(RedmineHelper.parseDate(root.elementText(CREATED_ON)));
        issue.setUpdated(RedmineHelper.parseDate(root.elementText(UPDATED_ON)));
        issue.setAssignee(root.valueOf("./assigned_to/@name"));
        issue.setIssueType(root.valueOf("./tracker/@name"));
        issue.setReporter(root.valueOf("./author/@name"));
        issue.setStatus(root.valueOf("./status/@name"));
        issue.setPriority(root.valueOf("./priority/@name"));
        return issue;
    }

    public static Document mapToIssueDocument(Map<String, String> map) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("issue");
        Element customNode = null;
        for (String each : map.keySet()) {
            if (each.startsWith(CUSTOM_FIELD)) {
                if (customNode == null) {
                    customNode = root.addElement("custom_fields");
                    customNode.addAttribute("type", "array");
                }
                Element n = customNode.addElement("custom_field");
                n.addAttribute(ID, each.substring(CUSTOM_FIELD.length()));
                Element valueNode = n.addElement("value");
                valueNode.setText(map.get(each));
                continue;
            }
            if (SUPPORTED_FIELDS_OF_CREATE.contains(each)) {
                Element node = root.addElement(each);
                node.setText(map.get(each));
                continue;
            }
            Context.getLogger().warn("The property " + each + " is unsupported, ignore ...");
        }
        return doc;
    }

    static Date parseDate(String str) {
        return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(str).toDate();
    }
}

