/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.redmine;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.RestClientFactory;
import com.pmease.quickbuild.plugin.tracker.redmine.RedmineHelper;
import com.pmease.quickbuild.plugin.tracker.redmine.RedmineSetting;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedmineCli {
    private static final Logger logger = LoggerFactory.getLogger(RedmineCli.class);
    private final String host;
    private final String username;
    private final String password;
    private final String projectId;

    public RedmineCli(String username, String password, String host, String projectId) {
        this.host = host;
        this.projectId = projectId;
        this.username = username;
        this.password = password;
    }

    public static RedmineCli newInstance() {
        RedmineSetting setting = RedmineSetting.get();
        return new RedmineCli(setting.getUser(), setting.getPassword(), setting.getHost(), setting.getAssociatedProject());
    }

    String getIssueDocument(String id) {
        logger.debug("Retriving issue " + id);
        ClientResponse response = this.getRestXMLResponse("/issues/" + id + ".xml");
        int status = response.getStatus();
        if (status == 200) {
            return (String)response.getEntity(String.class);
        }
        if (status == 404) {
            return null;
        }
        throw new TrackerException("Fetch issue " + id + " failed. " + response);
    }

    public Issue getIssue(String id) {
        String doc = this.getIssueDocument(id);
        return RedmineHelper.parseIssue(doc);
    }

    public Issue createIssue(Map<String, String> options) {
        Document doc = RedmineHelper.mapToIssueDocument(options);
        System.out.println(doc.asXML());
        ClientResponse response = (ClientResponse)this.resource().path("/projects/" + this.projectId + "/issues.xml").type("text/xml").post(ClientResponse.class, (Object)doc.asXML());
        int status = response.getStatus();
        String entity = (String)response.getEntity(String.class);
        if (status == 201) {
            return RedmineHelper.parseIssue(entity);
        }
        throw new TrackerException("Create issue failed. " + response);
    }

    public List<String> getProjects() {
        return Collections.emptyList();
    }

    private ClientResponse getRestXMLResponse(String path) {
        WebResource resource = this.resource().path(path);
        try {
            return (ClientResponse)resource.accept(new String[]{"text/xml"}).get(ClientResponse.class);
        }
        catch (Exception e) {
            throw new TrackerException("Unable to get response from URI " + path, (Throwable)e);
        }
    }

    private Document getRestXML(String path) {
        ClientResponse response = this.getRestXMLResponse(path);
        int status = response.getStatus();
        if (status != 200) {
            throw new TrackerException("Unable to get priorities from remote server with status " + status);
        }
        String xml = (String)response.getEntity(String.class);
        return XMLHelper.readXML((String)xml);
    }

    private BiMap<Integer, String> getNamedEntities(String path, String elementName) {
        Document doc = this.getRestXML(path);
        HashBiMap map = HashBiMap.create();
        for (Object node : doc.getRootElement().elements(elementName)) {
            Element e = (Element)node;
            Integer id = Integer.valueOf(e.elementText("id"));
            String name = e.elementText("name");
            map.put((Object)id, (Object)name);
        }
        return map;
    }

    public BiMap<Integer, String> getPriorities() {
        return this.getNamedEntities("/enumerations/issue_priorities.xml", "issue_priority");
    }

    public BiMap<Integer, String> getStatuses() {
        return this.getNamedEntities("/issue_statuses.xml", "issue_status");
    }

    public BiMap<Integer, String> getTrackers() {
        return this.getNamedEntities("/trackers.xml", "tracker");
    }

    public BiMap<Integer, String> getCustomFields() {
        return this.getNamedEntities("/custom_fields.xml", "custom_field");
    }

    public Integer findUserId(String name) {
        WebResource resource = this.resource().path("/users.xml").queryParam("name", name);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"text/xml", "application/xml"}).get(ClientResponse.class);
        int status = response.getStatus();
        if (status == 200) {
            String xml = (String)response.getEntity(String.class);
            if (Strings.isNullOrEmpty((String)xml)) {
                throw new TrackerException("Unable to find any user matching name like " + name);
            }
            Document doc = XMLHelper.readXML((String)xml);
            for (Object each : doc.getRootElement().elements("user")) {
                Element e = (Element)each;
                String login = e.elementText("login");
                if (!Objects.equal((Object)login, (Object)name)) continue;
                return Integer.valueOf(e.elementText("id"));
            }
        }
        throw new TrackerException("Unable to find any user matching name like " + name);
    }

    WebResource resource() {
        return RestClientFactory.resource((String)this.host, (String)this.username, (String)this.password);
    }
}

