/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.redmine;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.plugin.tracker.redmine.RedmineCli;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create Redmine Issue", category={"Issue Tracker"}, description="This step creates a bug/issue in defined Redmine server")
public class CreateIssueStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String issueSummary;
    private String issueDescription;
    private String issuePriority;
    private String trackerType;
    private String author;
    private String assignedTo;

    public void run() {
        Integer id;
        Integer id2;
        BiMap<Integer, String> bm;
        this.onBeforeRun();
        RedmineCli cli = RedmineCli.newInstance();
        String extraOptions = this.getExtraAttributes();
        Map map = StringHelper.getOptionsFromDefinition((String)extraOptions);
        map.put("subject", this.getIssueSummary());
        String str = this.getIssueDescription();
        if (!Strings.isNullOrEmpty((String)str)) {
            map.put("description", str);
        }
        if (!Strings.isNullOrEmpty((String)(str = this.getIssuePriority()))) {
            bm = cli.getPriorities();
            id2 = (Integer)bm.inverse().get((Object)str);
            if (id2 == null) {
                throw new QuickbuildException("Priority " + str + " doesn't exist");
            }
            map.put("priority_id", String.valueOf(id2));
        }
        if (!Strings.isNullOrEmpty((String)(str = this.getTrackerType()))) {
            bm = cli.getTrackers();
            id2 = (Integer)bm.inverse().get((Object)str);
            if (id2 == null) {
                throw new QuickbuildException("Tracker " + str + " doesn't exist");
            }
            map.put("tracker_id", String.valueOf(id2));
        }
        if (!Strings.isNullOrEmpty((String)(str = this.getAuthor()))) {
            id = cli.findUserId(str);
            map.put("author_id", String.valueOf(id));
        }
        if (!Strings.isNullOrEmpty((String)(str = this.getAssignedTo()))) {
            id = cli.findUserId(str);
            map.put("assigned_to_id", String.valueOf(id));
        }
        this.adjustCustomFields(cli, map);
        Issue issue = cli.createIssue(map);
        this.getIssueActions().put(issue.getIssueKey(), "create");
        Context.getLogger().info("Issue: " + issue + " created successfully.");
        this.onAfterRun();
    }

    private void adjustCustomFields(RedmineCli cli, Map<String, String> map) {
        HashMap customMap = Maps.newHashMap();
        CaseInsensitiveMap cm = (CaseInsensitiveMap)map;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Long id;
            if (!entry.getKey().startsWith("cf_") || (id = TrackerHelper.extractLong((String)entry.getKey())) != null) continue;
            customMap.put(cm.getOriginalKey(entry.getKey()), entry.getValue());
        }
        if (!customMap.isEmpty()) {
            BiMap<Integer, String> fields = null;
            try {
                fields = cli.getCustomFields();
            }
            catch (TrackerException e) {
                throw new QuickbuildException("Unable to get custom fields response, if you are using custom field name, only Redmine 2.4 or later are supported.", (Throwable)e);
            }
            BiMap names = fields.inverse();
            for (Map.Entry entry : customMap.entrySet()) {
                String key = (String)entry.getKey();
                map.remove(key);
                String name = key.substring("cf_".length());
                Integer id = (Integer)names.get(name);
                map.put("cf_" + id, (String)entry.getValue());
            }
        }
    }

    @Editable(name="Issue Subject", order=1000)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue summary")
    public String getIssueSummary() {
        return this.issueSummary;
    }

    public void setIssueSummary(String issueSummary) {
        this.issueSummary = issueSummary;
    }

    @Editable(name="Issue Description", order=1100)
    @Multiline
    @Scriptable
    @ScriptApi(value="Get issue description")
    public String getIssueDescription() {
        return this.issueDescription;
    }

    public void setIssueDescription(String issueDescription) {
        this.issueDescription = issueDescription;
    }

    @Editable(name="Tracker Type", order=1200, description="Specify the issue tracker")
    @Scriptable
    @ScriptApi(value="Get issue tracker type")
    @ExpressionProvider(value="getAvailableTypes")
    public String getTrackerType() {
        return this.trackerType;
    }

    public void setTrackerType(String trackerType) {
        this.trackerType = trackerType;
    }

    @Editable(name="Issue Priority", description="Specify the issue priority", order=1300)
    @Scriptable
    @ScriptApi(value="Get issue priority")
    @ExpressionProvider(value="getAvailablePriorities")
    public String getIssuePriority() {
        return this.issuePriority;
    }

    public void setIssuePriority(String issuePriority) {
        this.issuePriority = issuePriority;
    }

    @Editable(name="Author", description="Specify the author name of the created issue", order=1500)
    @Scriptable
    @ScriptApi(value="Get author who will create the issue")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Editable(name="Assigned to", description="Specify the assignee of the created issue", order=1600)
    @Scriptable
    @ScriptApi(value="Get assigned to user")
    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    @Editable(order=3000, name="Extra Attributes", description="Specify extra attributes of the issue, with one attribute per line. For example:<br/><code>field_1=value1<br/>field2=value2</code>For custom fields, you can specify in format <i>cf_</i>{id} or <i>cf_</i>{name} like:<br/><code>cf_1 or cf_my field</code>, see more information on page: http://www.redmine.org/projects/redmine/wiki/Rest_Issues")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes which will be used to create issue.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    private static Map<String, String> getAvailablePriorities() {
        RedmineCli cli = RedmineCli.newInstance();
        BiMap<Integer, String> map = cli.getPriorities();
        return CreateIssueStep.biMapToMap(map);
    }

    private static Map<String, String> biMapToMap(BiMap<Integer, String> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList((Iterable)map.keySet());
        Collections.sort(list);
        for (Integer each : list) {
            result.put(map.get((Object)each), map.get((Object)each));
        }
        return result;
    }

    private static Map<String, String> getAvailableTypes() {
        RedmineCli cli = RedmineCli.newInstance();
        BiMap<Integer, String> map = cli.getTrackers();
        return CreateIssueStep.biMapToMap(map);
    }
}

