/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.email;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.AlarmManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.notifier.email.Attachment;
import com.pmease.quickbuild.plugin.notifier.email.EmailNotificationTemplate;
import com.pmease.quickbuild.plugin.notifier.email.EmailPlugin;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.util.EasyList;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmailNotifier
extends Notifier {
    private EmailPlugin plugin;

    public EmailNotifier(EmailPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getEmailList(Set<User> users) {
        HashSet emailList = new HashSet();
        for (User user : users) {
            String email;
            if (ScriptEngine.instance.interpolative(user.getEmail())) {
                if (!SecurityHelper.isScriptAllowed((User)user)) throw new QuickbuildException("Email of user '" + user.getName() + "' contains script " + "however this user is not allowed to create scripts.");
                email = ScriptEngine.instance.interpolate(user.getEmail(), Context.buildEvalContext((Object)user, null));
            } else {
                email = user.getEmail();
            }
            if (StringUtils.isBlank((String)email)) {
                Context.getLogger().warn("Can not send email notification to user '" + user.getName() + "': email not specified.");
                continue;
            }
            emailList.addAll(StringUtils.splitAndTrim((String)email));
        }
        if (emailList.isEmpty()) return null;
        return StringUtils.join(emailList, (String)",");
    }

    private EmailSetting getEmailSetting() {
        EmailSetting emailSetting = SettingManager.instance.getEmailSetting();
        if (emailSetting == null) {
            throw new QuickbuildException("Can not send notification through email as mail server is not configured. To configure mail server, please login as administrator and open page Administration/Email Setting");
        }
        return emailSetting;
    }

    public List<String> getChannelNames() {
        return EasyList.create((Object[])new String[]{"Email", "Email CC"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Map<String, Set<User>> users, Build build) {
        Context.push((Build)build);
        try {
            ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
            EmailNotificationTemplate template = (EmailNotificationTemplate)this.plugin.findConfigurationSetting(Context.getConfiguration(), true);
            if (template == null) {
                template = (EmailNotificationTemplate)scriptEngine.installInterpolator((Object)new EmailNotificationTemplate());
            }
            Set<User> toUsers = users.get("Email");
            Set<User> ccUsers = users.get("Email CC");
            String toList = null;
            if (toUsers != null) {
                toList = this.getEmailList(toUsers);
            }
            String ccList = null;
            if (ccUsers != null) {
                ccList = this.getEmailList(ccUsers);
            }
            ArrayList<File> attachments = new ArrayList<File>();
            for (Attachment attachment : template.getAttachments()) {
                File baseDir = FileUtils.resolvePath((File)build.getPublishDir(), (String)attachment.getSrcPath());
                for (File each : FileUtils.listFiles((File)baseDir, (String)attachment.getFilePatterns())) {
                    if (!each.isFile()) continue;
                    attachments.add(each);
                }
            }
            if (StringUtils.isNotBlank((String)toList) || StringUtils.isNotBlank((String)ccList)) {
                MiscUtils.sendMail((String)toList, (String)ccList, (String)template.getEmailSubject(), (String)VelocityUtils.evalTemplate((String)template.getEmailBody(), (Map)Context.buildEvalContext((Object)template, null), (List)Lists.newArrayList((Object[])new String[]{build.getPublishDir().getAbsolutePath()})), attachments, (EmailSetting)this.getEmailSetting(), (String)"text/html");
            }
        }
        finally {
            Context.pop();
        }
    }

    @Deprecated
    public void notify(Map<String, Set<User>> users, Alert alert) {
        Set<User> toUsers = users.get("Email");
        Set<User> ccUsers = users.get("Email CC");
        String toList = null;
        if (toUsers != null) {
            toList = this.getEmailList(toUsers);
        }
        String ccList = null;
        if (ccUsers != null) {
            ccList = this.getEmailList(ccUsers);
        }
        String subject = "[" + alert.getPriority() + "] " + alert.getSubject() + " on " + alert.getTrigger();
        MiscUtils.sendMail((String)toList, (String)ccList, (String)subject, (String)alert.toString(), new ArrayList(), (EmailSetting)this.getEmailSetting(), (String)"text/plain");
    }

    public void notify(NodeAlertEvent event) {
        Map users = AlarmManager.instance.getNotifierUsers((Notifier)this);
        if (users.isEmpty()) {
            return;
        }
        Set toUsers = (Set)users.get("Email");
        Set ccUsers = (Set)users.get("Email CC");
        String toList = null;
        if (toUsers != null) {
            toList = this.getEmailList(toUsers);
        }
        String ccList = null;
        if (ccUsers != null) {
            ccList = this.getEmailList(ccUsers);
        }
        String subject = "Alert report - " + event.getNodeAddress() + " [" + event.getAlerts().size() + " alerts]";
        String template = EmailPlugin.getInstance().getAlertsTemplate();
        HashMap<String, NodeAlertEvent> map = new HashMap<String, NodeAlertEvent>();
        map.put("report", event);
        String content = VelocityUtils.evalTemplate((String)template, map);
        MiscUtils.sendMail((String)toList, (String)ccList, (String)subject, (String)content, new ArrayList(), (EmailSetting)this.getEmailSetting(), (String)"text/html");
    }
}

