/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.email;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.notifier.email.Attachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Notification Template"}, description="This template will be used to construct email build notification message of this configuration if necessary. If not specified, template of parent configuration will be used.")
@ScriptApi
public class EmailNotificationTemplate {
    private String emailSubject = "Build '${build.version}' of configuration '${configuration.pathName}' is ${build.status.name()}";
    private String emailBody = "#parse (\"default_html_notification.vm\")";
    private List<Attachment> attachments = new ArrayList<Attachment>();

    @Editable(order=100, description="Specify subject of the build notification email.")
    @NotEmpty
    @ScriptApi(value="Get subject of the notification email.")
    @Scriptable
    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    @Editable(order=200, description="Specify a <a href=\"http://velocity.apache.org\">Velocity</a> template here. Evaluation result of the template will be used as content of the notification email. Velocity resource loader path is configured to include below paths when this template is evaluated: <ul><li><em>asset</em> sub folder under QuickBuild server's installation directory.</li><li>publish directory of the current build</li></ul>So for instance if you want to include a file &quot;issues.txt&quot; under build artifacts directory, you may call <i>#include( &quot;artifacts/issues.txt&quot; )</i> in the template.<br>Also refer to template context help below for objects contained in the Velocity context.")
    @Multiline(value=10)
    @NotEmpty
    @ScriptApi(value="Get body template of the notification email.")
    @Template
    public String getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }

    @Editable(order=300, description="Specify email attachments.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element attachmentsElement = dom.getRootElement().addElement("attachments");
        Element attachFilesElement = dom.getRootElement().element("attachFiles");
        if (attachFilesElement != null) {
            Element attachmentElement = attachmentsElement.addElement("com.pmease.quickbuild.plugin.notifier.email.Attachment");
            attachmentElement.addElement("filePatterns").setText(attachFilesElement.getText().trim());
            attachFilesElement.detach();
        }
    }
}

