/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.tap.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerFactory;
import org.tap4j.model.BailOut;
import org.tap4j.model.TestSet;

public class TestSetProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;

    public TestSetProcessor(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return TestSetProcessor.class.getName();
    }

    protected AbstractRule createDefaultRule() {
        return null;
    }

    protected ResourceReader<?> createDefaultReader() {
        return null;
    }

    protected void processResource(GeneratorResource resource) {
        File file = (File)Preconditions.checkNotNull((Object)resource.getFile(), (Object)"file");
        TapConsumer consumer = TapConsumerFactory.makeTap13YamlConsumer();
        TestSet ts = consumer.load(file);
        String fileName = FilenameUtils.getBaseName((String)file.getName());
        DataReport report = GeneratorContext.getContext().getDestReport();
        DataRow row = report.addRow();
        row.setValue("fileName", (Object)fileName);
        if (ts.containsBailOut().booleanValue()) {
            row.setValue("status", (Object)"BAILOUT");
            ArrayList reasons = Lists.newArrayList();
            for (BailOut each : ts.getBailOuts()) {
                reasons.add(each.getReason());
            }
            row.setValue("bailoutReasons", (Object)reasons);
        } else if (ts.containsNotOk().booleanValue()) {
            row.setValue("status", (Object)"ERROR");
        } else {
            row.setValue("status", (Object)"PASS");
        }
    }
}

