/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.tap.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.tap.generator.TapTest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerFactory;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;

public class TestProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;

    public TestProcessor(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return TestProcessor.class.getName();
    }

    protected AbstractRule createDefaultRule() {
        return null;
    }

    protected ResourceReader<?> createDefaultReader() {
        return null;
    }

    protected void processResource(GeneratorResource resource) {
        File file = (File)Preconditions.checkNotNull((Object)resource.getFile(), (Object)"file");
        TapConsumer consumer = TapConsumerFactory.makeTap13YamlConsumer();
        TestSet ts = consumer.load(file);
        List<TapTest> list = TestProcessor.buildTests(null, ts);
        String fileName = FilenameUtils.getBaseName((String)file.getName());
        DataReport report = GeneratorContext.getContext().getDestReport();
        for (TapTest each : list) {
            DataRow row = report.addRow();
            row.setValue("fileName", (Object)fileName);
            row.setValue("number", (Object)each.getNumber());
            row.setValue("comments", (Object)each.getComment());
            row.setValue("description", (Object)each.getDescription());
            row.setValue("directive", (Object)each.getDirective());
            row.setValue("directiveReasons", (Object)each.getReason());
            row.setValue("status", (Object)each.getStatus());
            row.setValue("duration", (Object)each.getDuration());
        }
    }

    private static List<TapTest> buildTests(TapTest parent, TestSet testset) {
        ArrayList results = Lists.newArrayList();
        for (TestResult each : testset.getTestResults()) {
            TapTest test = new TapTest(parent, each);
            results.add(test);
            if (each.getSubtest() == null) continue;
            List<TapTest> subs = TestProcessor.buildTests(test, each.getSubtest());
            results.addAll(subs);
        }
        return results;
    }
}

