/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.tap.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.tap4j.model.Comment;
import org.tap4j.model.TestResult;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public class TapTest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TapTest parent;
    private final String number;
    private final String description;
    private final String directive;
    private final String reason;
    private final String status;
    private final String comment;
    private final long duration;
    private static final String DURATION_KEY = "duration_ms";

    public TapTest(TapTest parent, TestResult result) {
        this.parent = parent;
        this.number = parent == null ? String.valueOf(result.getTestNumber()) : parent.number + "." + result.getTestNumber();
        this.description = result.getDescription();
        if (result.getDirective() != null) {
            this.directive = result.getDirective().getDirectiveValue().name();
            this.reason = result.getDirective().getReason();
        } else {
            this.directive = null;
            this.reason = null;
        }
        ArrayList lines = Lists.newArrayList();
        for (Comment each : result.getComments()) {
            lines.add(each.getText());
        }
        this.comment = Joiner.on((String)"\n").join((Iterable)lines);
        this.status = this.getStatus(result);
        this.duration = this.getDuration(result);
    }

    private String getStatus(TestResult result) {
        if (result.getDirective() != null && result.getDirective().getDirectiveValue() == DirectiveValues.SKIP) {
            return "SKIP";
        }
        if (result.getStatus() == StatusValues.OK) {
            return "PASS";
        }
        return "ERROR";
    }

    private long getDuration(TestResult result) {
        Map diagnostics = result.getDiagnostic();
        if (diagnostics != null && diagnostics.containsKey(DURATION_KEY)) {
            return (Long)DataTypes.LONG.typeCast((Object)diagnostics.get(DURATION_KEY).toString());
        }
        return 0L;
    }

    public TapTest getParent() {
        return this.parent;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDirective() {
        return this.directive;
    }

    public String getReason() {
        return this.reason;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComment() {
        return this.comment;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TapTest)) {
            return false;
        }
        TapTest rhs = (TapTest)other;
        return Objects.equal((Object)this.parent, (Object)rhs.parent) && Objects.equal((Object)this.number, (Object)rhs.number);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parent, this.number});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("#", (Object)this.number).add("description", (Object)this.description).add("duration", this.duration).add("directive", (Object)this.directive).add("reason", (Object)this.reason).add("status", (Object)this.status).add("comment", (Object)this.comment).toString();
    }
}

