/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.tap.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.tap.TapPlugin;
import com.pmease.quickbuild.plugin.report.tap.renderer.TapStatsRenderer;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="TAP Stats", category={"Unit Test Statistics"})
public class TapStatsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;

    protected StatisticsRenderer createRenderer() {
        ReportCategory category = ReportHelper.getCategory(TapPlugin.class);
        TapStatsRenderer r = new TapStatsRenderer(category);
        r.setSimpleMode(true);
        return r;
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Success Rate", "Total Tests", "Failed Tests", "Passed Tests", "Skipped Tests", "Duration"});
    }
}

