/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.tap;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.tap.TapPlugin;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="TAP Report", description="Publish TAP reports")
@ScriptApi(value="This step publishes the original TAP files.")
public class TapPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int errors;
    @XStreamOmitField
    private int tests;
    @XStreamOmitField
    private int skips;

    public TapPublisher() {
        this.setStepFailureCondition("current.errors > 0");
        this.setStepFailureMessage("Found failed tests in TAP report.");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(TapPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "TapPublisher::saveStatsReport");
            Map map = category.getDefaultStats(db, "testsets", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(map);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            this.tests = MapUtils.getLong((Map)map, (Object)"tests", (Long)0L).intValue();
            this.errors = MapUtils.getLong((Map)map, (Object)"errors", (Long)0L).intValue();
            this.skips = MapUtils.getLong((Map)map, (Object)"skips", (Long)0L).intValue();
            double successRate = MathUtils.divide((int)(this.tests - this.errors - this.skips), (int)this.tests);
            row.setValue("success_rate", (Object)successRate);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"has failed tests", "current.errors > 0", "I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @Editable(order=800, name="Files to Process", description="Specify TAP reports to be processed. Path specified here is relative to source directory specified above, for example <b>reports/tap/*.tap</b> stands for all the files with <b>.tap</b> suffix under the <b>reports/tap</b> sub directory relative to the source directory. Refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @NotEmpty
    @ScriptApi(value="Get report files or patterns")
    @Scriptable
    public String getFilePattern() {
        return super.getFilePattern();
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return TapChecksum.class;
    }

    @ScriptApi(value="Total errors in TAP report.")
    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    @ScriptApi(value="Total tests in TAP report.")
    public int getTests() {
        return this.tests;
    }

    public void setTests(int tests) {
        this.tests = tests;
    }

    @ScriptApi(value="Total skips in JUnit report.")
    public int getSkips() {
        return this.skips;
    }

    public void setSkips(int skips) {
        this.skips = skips;
    }

    public static class TapChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(TapPlugin.class);
        }
    }
}

