/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.gerrit;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.gerrit.GerritPlugin;
import com.pmease.quickbuild.plugin.scm.gerrit.LabelScoring;
import com.pmease.quickbuild.plugin.scm.gerrit.ShortBranchCustomData;
import com.pmease.quickbuild.plugin.scm.git.GitProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Gerrit", description="Define a Gerrit repository here. This repository can be used to verify gerrit changes.")
public class GerritRepository
extends GitRepository
implements Validatable {
    private String gerritUrl;
    private String project;
    private String changeNumbers;
    private AuthMode authMode = AuthMode.DIGEST;
    private LabelScoring labelScoring;

    public String getFetchUrl() {
        return StringUtils.stripEnd((String)this.getGerritUrl(), (String)"/") + "/" + this.getProject();
    }

    public String getPushUrl() {
        return super.getPushUrl();
    }

    @Editable(name="Gerrit Root URL", order=1100, description="Root url to access gerrit. For instance: http://gerrit-server:8080")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get gerrit root URL.")
    public String getGerritUrl() {
        return this.gerritUrl;
    }

    public void setGerritUrl(String gerritUrl) {
        this.gerritUrl = gerritUrl;
    }

    @Editable(name="Gerrit Project", order=1120, description="Specify project to build changes of.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get Gerrit Project.")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Editable(name="Change Numbers", order=1130, description="Optionally specify open change numbers to build against. Multiple change numbers should be separated with comma. If not specified, all open changes will be built.")
    @Scriptable
    public String getChangeNumbers() {
        return this.changeNumbers;
    }

    public void setChangeNumbers(String changeNumbers) {
        this.changeNumbers = changeNumbers;
    }

    @Editable(name="Http Authentication Mode", order=1150, description="Select appropriate http authentication mode. Gerrit supports &quot;DIGEST&quot; by default, but &quot;BASIC&quot; should be used if http basic authentication is enabled on gerrit side via option &quot;auth.gitBasicAuth&quot; in gerrit config file.")
    @NotNull
    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(AuthMode authMode) {
        this.authMode = authMode;
    }

    @Editable(order=1200, name="User Name", description="Specify the user who has permission to access the above project.")
    @ScriptApi(value="Get the user name used to clone above project.")
    @Scriptable
    @NotEmpty
    public String getUserName() {
        return super.getUserName();
    }

    @Editable(order=1300, description="Specify http password of the above user. If http basic authentication is turned on, this password will be the same as the password used to login to gerrit web UI if http basic authentication is turned on; otherwise, it should be generated via user setting page at gerrit side.")
    @Password
    @ScriptApi(value="Get http password of above user.")
    @NotEmpty
    @Scriptable
    public String getPassword() {
        return super.getPassword();
    }

    @Editable(order=1400, description="Specify branch of changes to build. If not specified, open changes of all branches will be built.")
    @Scriptable
    public String getBranch() {
        return super.getBranch();
    }

    @Editable(order=1600, description="Check this is you want to score gerrit label after build finishes.")
    public LabelScoring getLabelScoring() {
        return this.labelScoring;
    }

    public void setLabelScoring(LabelScoring labelScoring) {
        this.labelScoring = labelScoring;
    }

    public String getBuildRevision() {
        return super.getBuildRevision();
    }

    public GitProofBuildSupport getProofBuildSupport() {
        return super.getProofBuildSupport();
    }

    public String getActualBranch() {
        if (this.getBuild().getRequest().getShortBranch() != null) {
            return this.getBuild().getRequest().getShortBranch().getName();
        }
        throw new QuickbuildException("Unable to determine short branch to build against.");
    }

    @ScriptApi
    public Collection<ShortBranch> getOpenChanges() {
        try {
            String url = StringUtils.stripEnd((String)this.getGerritUrl(), (String)"/");
            String restUrl = url + "/a/changes/";
            String query = "q=project:" + URLEncoder.encode(this.getProject(), "UTF8");
            if (this.getBranch() != null) {
                query = query + "+branch:" + URLEncoder.encode(this.getBranch(), "UTF8");
            }
            query = query + "+is:open";
            String fields = "o=current_revision";
            WebResource resource = RestModule.resource((String)(restUrl + "?" + query + "&" + fields + "&pp=0"), (String)this.getUserName(), (String)this.getPassword(), (this.getAuthMode() == AuthMode.DIGEST ? 1 : 0) != 0);
            ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
            if (response.getStatus() == 401) {
                throw new QuickbuildException("Unauthorized: please make sure you've specified http authentication mode and password appropriately.");
            }
            if (response.getStatus() != 200) {
                throw new QuickbuildException("Error retrieving gerrit changes: " + (String)response.getEntity(String.class));
            }
            String json = StringUtils.stripStart((String)((String)response.getEntity(String.class)), (String)")]}'");
            ArrayList<ShortBranch> shortBranches = new ArrayList<ShortBranch>();
            for (Map change : (List)GerritPlugin.OBJECT_MAPPER.readValue(json, List.class)) {
                ShortBranch shortBranch = new ShortBranch();
                shortBranch.setRevision((String)change.get("current_revision"));
                int changeNo = (Integer)change.get("_number");
                ShortBranchCustomData customData = new ShortBranchCustomData();
                customData.id = (String)change.get("id");
                customData.subject = (String)change.get("subject");
                customData.changeNo = String.valueOf(changeNo);
                shortBranch.setCustomData((Serializable)customData);
                Map revisions = (Map)change.get("revisions");
                Map revisionMap = (Map)revisions.get(shortBranch.getRevision());
                int patchNo = (Integer)revisionMap.get("_number");
                shortBranch.setName(String.format("refs/changes/%02d/%d/%d", changeNo % 100, changeNo, patchNo));
                shortBranches.add(shortBranch);
            }
            return shortBranches;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ShortBranch> getShortBranches() {
        String changeNumbers = this.getChangeNumbers();
        ArrayList changeNumberList = changeNumbers != null ? StringUtils.splitAndTrim((String)changeNumbers) : new ArrayList();
        ArrayList<ShortBranch> shortBranches = new ArrayList<ShortBranch>();
        for (ShortBranch each : this.getOpenChanges()) {
            StringTokenizer tokenizer = new StringTokenizer(each.getName(), "/");
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            String changeNo = tokenizer.nextToken();
            if (!changeNumberList.isEmpty() && !changeNumberList.contains(changeNo)) continue;
            shortBranches.add(each);
        }
        return shortBranches;
    }

    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("fetchUrl")) {
            if (!this.getFetchUrl().contains("http://") && !this.getFetchUrl().contains("https://")) {
                errorContext.setError("fetchUrl", "Please specify the http(s) url to clone the project.");
            } else if (this.getFetchUrl().contains("@")) {
                errorContext.setError("fetchUrl", "Please do not include user name or password in the url. User name and password should be specified below separately.");
            }
        }
    }

    public static enum AuthMode {
        BASIC,
        DIGEST;

    }
}

