/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.gerrit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.extensionpoint.RepositoryProvider;
import com.pmease.quickbuild.plugin.scm.gerrit.GerritRepository;
import com.pmease.quickbuild.plugin.scm.gerrit.ShortBranchCustomData;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.rest.RestModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class GerritPlugin
extends AbstractPlugin {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Object[] getExtensions() {
        return new Object[]{new RepositoryProvider(){

            public Class<? extends Repository<?>> getRepositoryClass() {
                return GerritRepository.class;
            }
        }, new BuildListener(){

            public void buildUnRecommended() {
            }

            public void buildStarted() {
            }

            public void buildRecommended() {
            }

            public void buildFinished() {
                for (Repository repo : Context.getBuild().getRepositories()) {
                    if (!(repo instanceof GerritRepository)) continue;
                    GerritRepository gerritRepo = (GerritRepository)repo;
                    try {
                        WebResource resource;
                        ClientResponse response;
                        HashMap<String, Integer> labelData;
                        String url = StringUtils.stripEnd((String)gerritRepo.getGerritUrl(), (String)"/");
                        Serializable customData = Context.getRequest().getShortBranch().getCustomData();
                        String changeId = customData instanceof ShortBranchCustomData ? ((ShortBranchCustomData)customData).id : (String)((Object)customData);
                        String restUrl = url + "/a/changes/" + changeId + "/revisions/" + ((GitRevision)gerritRepo.getRevision()).getValue() + "/review";
                        HashMap<String, Object> review = new HashMap<String, Object>();
                        if (Context.getBuild().isSuccessful() || Context.getBuild().isRecommended()) {
                            review.put("message", String.format("Build %s is successful: %s", Context.getBuild().getVersion(), Context.getBuild().getUrl()));
                            if (gerritRepo.getLabelScoring() != null) {
                                labelData = new HashMap<String, Integer>();
                                labelData.put(gerritRepo.getLabelScoring().getLabelToScore(), gerritRepo.getLabelScoring().getSuccessfulScore());
                                review.put("labels", labelData);
                            }
                        } else {
                            review.put("message", String.format("Build %s is failed: %s", Context.getBuild().getVersion(), Context.getBuild().getUrl()));
                            if (gerritRepo.getLabelScoring() != null) {
                                labelData = new HashMap();
                                labelData.put(gerritRepo.getLabelScoring().getLabelToScore(), gerritRepo.getLabelScoring().getFailedScore());
                                review.put("labels", labelData);
                            }
                        }
                        if ((response = (ClientResponse)(resource = RestModule.resource((String)restUrl, (String)gerritRepo.getUserName(), (String)gerritRepo.getPassword(), (gerritRepo.getAuthMode() == GerritRepository.AuthMode.DIGEST ? 1 : 0) != 0)).type("application/json").post(ClientResponse.class, (Object)OBJECT_MAPPER.writeValueAsString(review))).getStatus() == 200) continue;
                        throw new QuickbuildException("Error posting review data: " + (String)response.getEntity(String.class));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }};
    }
}

