/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.model.ChangeFormatter;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Modification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNCLEAR_PREFIX = "...";
    private String action;
    private String path;
    private String edition;
    private String previousEdition;
    private String pathType;
    private String additional;

    public boolean canViewSource() {
        return !StringUtils.isEmpty((String)this.getPath()) && !StringUtils.isEmpty((String)this.getEdition()) && !"DELETE".equalsIgnoreCase(this.getAction()) && !"BINARY".equalsIgnoreCase(this.getPathType()) && !"DIR".equalsIgnoreCase(this.getPathType());
    }

    public boolean canDiffSource() {
        return !StringUtils.isEmpty((String)this.getPath()) && !StringUtils.isEmpty((String)this.getEdition()) && !StringUtils.isEmpty((String)this.getPreviousEdition()) && !"ADD".equalsIgnoreCase(this.getAction()) && !"DELETE".equalsIgnoreCase(this.getAction()) && !"BINARY".equalsIgnoreCase(this.getPathType()) && !"DIR".equalsIgnoreCase(this.getPathType());
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDisplayEdition(String repositoryType) {
        ChangeFormatter.RepositoryType type = ChangeFormatter.RepositoryType.fromString(repositoryType);
        switch (type) {
            case MERCURIAL: 
            case GIT: {
                return ChangeFormatter.formatHashId(this.edition, this.additional);
            }
            case BAZAAR: {
                return ChangeFormatter.formatBzrId(this.edition, this.additional);
            }
        }
        return this.edition;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public String getPreviousEdition() {
        return this.previousEdition;
    }

    public void setPreviousEdition(String previousEdition) {
        this.previousEdition = previousEdition;
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        TEXT,
        BINARY,
        DIR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD,
        DELETE,
        MODIFY;

    }
}

