/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.model.BuildChangeset;
import com.pmease.quickbuild.addons.jira.model.ChangeFormatter;
import com.pmease.quickbuild.addons.jira.model.Modification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changeset
implements Serializable,
Comparable<Changeset> {
    private static final long serialVersionUID = 1L;
    private Long buildId;
    private String id;
    private String repositoryName;
    private String user;
    private Date date;
    private String comment;
    private String additional;
    private String repositoryType;
    private List<Modification> modifications = new ArrayList<Modification>();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDisplayId() {
        ChangeFormatter.RepositoryType type = ChangeFormatter.RepositoryType.fromString(this.repositoryType);
        switch (type) {
            case MERCURIAL: 
            case GIT: {
                return ChangeFormatter.formatHashId(this.id, this.additional);
            }
            case BAZAAR: {
                return ChangeFormatter.formatBzrId(this.id, this.additional);
            }
        }
        return this.id;
    }

    public Long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(Long buildId) {
        this.buildId = buildId;
    }

    String bzrShortId(String id) {
        int pos = id.lastIndexOf(45);
        if (pos > 0) {
            return id.substring(pos + 1);
        }
        return id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<Modification> modifications) {
        this.modifications = modifications;
    }

    public void addModification(Modification modification) {
        if (modification != null) {
            this.modifications.add(modification);
        }
    }

    public String getChangesetId() {
        return new StringBuffer(this.getId()).append(':').append(this.repositoryName).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof BuildChangeset)) {
            return false;
        }
        Changeset rhs = (Changeset)other;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append((Object)this.repositoryName, (Object)rhs.repositoryName).append((Object)this.date, (Object)rhs.date).isEquals();
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.repositoryName).append((Object)this.date).toHashCode();
    }

    @Override
    public int compareTo(Changeset other) {
        if (other == null) {
            return 1;
        }
        int result = this.repositoryName.compareTo(other.repositoryName);
        if (result != 0) {
            return result;
        }
        if (this.getDate() == null) {
            return 1;
        }
        if (other.getDate() == null) {
            return -1;
        }
        return other.getDate().compareTo(this.getDate());
    }

    public String toString() {
        String[] lines;
        StringBuffer sb = new StringBuffer();
        sb.append("--------------------------------------------------------------------------------\n");
        sb.append("Revision:       ").append(this.getId()).append("\n");
        sb.append("User:           ").append(this.getUser()).append("\n");
        sb.append("Date:           ").append(this.getDate()).append("\n");
        sb.append("Comment:        \n");
        for (String each : lines = StringUtils.split((String)this.getComment(), (char)'\n')) {
            sb.append("  ").append(each).append("\n");
        }
        sb.append("Modifications:  \n");
        for (Modification m : this.modifications) {
            sb.append("  ").append(m.getAction()).append("\t").append(m.getPath()).append("\tC").append(m.getEdition()).append(";").append("C").append(m.getPreviousEdition()).append("\t").append(m.getPathType()).append("\n");
        }
        return sb.toString();
    }
}

