/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.issuepanels;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.issue.ViewIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.user.User;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.issuepanels.FeedbackAction;
import com.pmease.quickbuild.addons.jira.issuepanels.IssueBuildsAction;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;

public class IssueBuildsTabPanel
extends AbstractIssueTabPanel {
    private static final Logger logger = Logger.getLogger(IssueBuildsTabPanel.class);
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final QuickBuildManager qbManager;
    private final VelocityRequestContextFactory requestContextFactory;

    public IssueBuildsTabPanel(QuickBuildManager qbManager, PermissionManager permissionManager, WebResourceManager webResourceManager, VelocityRequestContextFactory requestContextFactory) {
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
        this.requestContextFactory = requestContextFactory;
    }

    public List getActions(Issue issue, User user) {
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-css");
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-js");
        try {
            List<RestResult<BuildSet>> builds = this.qbManager.getIssueBuilds(issue);
            boolean isDesc = !this.isSortingActionsInAscendingOrder();
            for (RestResult<BuildSet> rr : builds) {
                BuildSet buildset = rr.getResult();
                if (buildset == null) continue;
                buildset.sort(!isDesc);
            }
            IssueBuildsAction action = new IssueBuildsAction(this.descriptor, builds, this.qbManager);
            return EasyList.build((Object)((Object)action));
        }
        catch (Exception e) {
            logger.error((Object)"Retrieve builds failed.", (Throwable)e);
            FeedbackAction action = new FeedbackAction("<h3>Retrieve Builds Failed!</h3><p>" + e.getMessage() + "</p>", FeedbackAction.Level.ERROR);
            return EasyList.build((Object)((Object)action));
        }
    }

    boolean isSortingActionsInAscendingOrder() {
        try {
            Action viewIssueAction = ActionFactory.getActionFactory().getActionImpl(ViewIssue.class.getName());
            return !StringUtils.equalsIgnoreCase((String)this.getActionSortOrder(viewIssueAction), (String)"desc");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to figure out how actions are sorted. I'm going to default to ascending", (Throwable)e);
            return true;
        }
    }

    private String getActionSortOrder(Action viewIssueAction) {
        String defaultOrder = ((ViewIssue)viewIssueAction).getApplicationProperties().getDefaultString("jira.issue.actions.order");
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String actionOrder = requestContext.getRequestParameter("actionOrder");
        VelocityRequestSession session = requestContext.getSession();
        if (StringUtils.isNotBlank((String)actionOrder)) {
            if (!actionOrder.equals(defaultOrder)) {
                session.setAttribute("jira.issue.action.order", (Object)actionOrder);
                return defaultOrder;
            }
            session.removeAttribute("jira.issue.action.order");
            return defaultOrder;
        }
        actionOrder = (String)session.getAttribute("jira.issue.action.order");
        if (StringUtils.isNotBlank((String)actionOrder)) {
            return actionOrder;
        }
        return defaultOrder;
    }

    public boolean showPanel(Issue issue, User user) {
        if (!this.permissionManager.hasPermission(29, issue, user)) {
            return false;
        }
        String projectKey = issue.getProjectObject().getKey();
        return this.qbManager.isProjectAssociated(projectKey);
    }
}

