/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsPriorToJiraVersion
implements Condition {
    private int maxMajorVersion;
    private int maxMinorVersion;
    private int majorVersion;
    private int minorVersion;

    public IsPriorToJiraVersion(ApplicationProperties applicationProperties) {
        String versionString = applicationProperties.getVersion();
        String versionRegex = "^(\\d+)\\.(\\d+)";
        Pattern versionPattern = Pattern.compile(versionRegex);
        Matcher versionMatcher = versionPattern.matcher(versionString);
        versionMatcher.find();
        this.majorVersion = Integer.decode(versionMatcher.group(1));
        this.minorVersion = Integer.decode(versionMatcher.group(2));
    }

    public void init(Map<String, String> paramMap) throws PluginParseException {
        this.maxMajorVersion = Integer.decode(paramMap.get("majorVersion"));
        this.maxMinorVersion = Integer.decode(paramMap.get("minorVersion"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.majorVersion < this.maxMajorVersion || this.majorVersion == this.maxMajorVersion && this.minorVersion < this.maxMinorVersion;
    }
}

