/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.rake;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.builder.rake.RakeSetting;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Rake", category={"Build"}, description="Configure a Rake build step here. By default, QuickBuild executes \"rake\" (or rake.bat on Windows) to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Rake plugin through the plugin management page.")
@ScriptApi(value="This step calls Rake to build projects.")
public class RakeBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String workingPath;
    private String buildScriptPath;
    private String buildTargets;
    private List<Property> buildProperties = new ArrayList<Property>();
    private String extraRakeOptions;
    private List<Property> environments = new ArrayList<Property>();
    private int returnCode;

    @Editable(order=1100, name="Rake Build File", description="Specify the path to Rake build file. A non-absolute path is considered to be relative to the workspace directory.")
    @ScriptApi(value="Get Rake build file path.")
    @NotEmpty
    @Scriptable
    public String getBuildScriptPath() {
        return this.buildScriptPath;
    }

    public void setBuildScriptPath(String buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
    }

    @Editable(order=1200, description="Specify the targets to build. Use space to separate different targets (target name containing spaces should be quoted in order not to be interpreted as multiple targets)")
    @ScriptApi(value="Get Rake build targets. Null if not specified.")
    @Scriptable
    public String getBuildTargets() {
        return this.buildTargets;
    }

    public void setBuildTargets(String buildTargets) {
        this.buildTargets = buildTargets;
    }

    @Editable(order=1300, description="Define build properties here to pass into the build script. For example, you may pass version of current build as property <i>buildVersion</i> by specifying property name as <i>buildVersion</i> and property value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Properties with blank value will be ignored.")
    @ScriptApi(value="Get list of build properties passed to Rake process.")
    public List<Property> getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(List<Property> buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Editable(order=1400, name="Working Directory", description="Optionally specify working directory of the Rake command. A non-absolute path will be considered to be relative to the directory containing the build script specified above. If not specified, the directory containing the build script will be used as working directory.")
    @ScriptApi(value="Get working directory of Rake command. Null if the directory containing the build script is used as working directory.")
    @Scriptable
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @Editable(order=1500, description="Optionally specify extra Rake options. Please note that you should not specify following options as they'll be added by Quickbuild based on other settings:<br><b>-f, --rakefile</b>")
    @ScriptApi(value="Get extra Rake options. Null if not specified.")
    @Scriptable
    @Advanced
    public String getExtraRakeOptions() {
        return this.extraRakeOptions;
    }

    public void setExtraRakeOptions(String extraRakeOptions) {
        this.extraRakeOptions = extraRakeOptions;
    }

    @Editable(name="Environment Variables", order=1600, description="Specify environment variables for Rake execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @ScriptApi(value="Get return code of Rake command.")
    public int getReturnCode() {
        return this.returnCode;
    }

    private Commandline getBuildCmd() {
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(this.getRakeExecutable());
        if (StringUtils.isNotBlank((String)this.getExtraRakeOptions())) {
            cmdLine.createArgument().setLine(this.getExtraRakeOptions());
        }
        for (Property property : this.getBuildProperties()) {
            if (!StringUtils.isNotBlank((String)property.getValue())) continue;
            cmdLine.createArgument().setValue(property.getName() + "=" + property.getValue());
        }
        String cmdLineDescription = cmdLine.describe();
        if (!(cmdLineDescription.matches(".*\\s(-q|-quiet)($|\\s.*)") || cmdLineDescription.matches(".*\\s(-v|-verbose)($|\\s.*)") || cmdLineDescription.matches(".*\\s(-d|-debug)($|\\s.*)"))) {
            if (!Context.getLogger().isInfoEnabled()) {
                cmdLine.createArgument().setValue("-q");
            } else if (Context.getLogger().isDebugEnabled()) {
                cmdLine.createArgument().setValue("-v");
            }
        }
        File buildScriptFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getBuildScriptPath());
        cmdLine.createArgument().setValue("--rakefile");
        cmdLine.createArgument().setValue(buildScriptFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.getBuildTargets())) {
            cmdLine.createArgument().setLine(this.getBuildTargets());
        }
        return cmdLine;
    }

    private File getWorkingDir() {
        File buildScriptFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getBuildScriptPath());
        return FileUtils.resolvePath((File)buildScriptFile.getParentFile(), (String)this.getWorkingPath());
    }

    private String getRakeExecutable() {
        String rakeExe = ((RakeSetting)this.getPlugin().getSetting(true)).getRakeExecutablePath();
        if (rakeExe == null) {
            rakeExe = SystemUtils.IS_OS_WINDOWS ? "rake.bat" : "rake";
        }
        return rakeExe;
    }

    public void run() {
        Commandline cmdline = this.getBuildCmd();
        Environment env = new Environment();
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        final boolean[] failed = new boolean[]{false};
        this.returnCode = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().info(line);
                if (line.contains("rake aborted") || line.contains("Command failed with status")) {
                    failed[0] = true;
                }
            }
        }, new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().warn(line);
                if (line.contains("rake aborted") || line.contains("Command failed with status")) {
                    failed[0] = true;
                }
            }
        }).getReturnCode();
        if (failed[0]) {
            throw new QuickbuildException("Rake build failed.");
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("rakeWorkingPath");
        if (element != null) {
            element.detach();
            dom.getRootElement().addElement("workingPath").setText(element.getTextTrim());
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        root.element("commandSuccessCondition").detach();
        root.element("environmentVariables").setName("environments");
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }
}

