/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.renderer;

import com.google.common.collect.Range;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.web.chart.LineChartBuilder;
import com.pmease.quickbuild.plugin.report.engine.web.chart.XYChartData;
import com.pmease.quickbuild.plugin.report.jmeter.renderer.SampleTableRenderer;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import java.util.Calendar;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RequestSamplePanel
extends AbstractReportPanel {
    public RequestSamplePanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.renderTable();
        this.add(new Component[]{new JFreeChartPanel("chart", 590, 300, (IModel)new LoadableDetachableModel<JFreeChart>(){

            protected JFreeChart load() {
                return RequestSamplePanel.this.loadChart();
            }
        })});
    }

    private JFreeChart loadChart() {
        return new LineChartBuilder((XYChartData)new com.pmease.quickbuild.plugin.report.engine.web.chart.XYSeries(this.loadChartData()){

            public String domainLabel(double value) {
                return DataTypes.DATE.asString((Object)new Date(new Double(value).longValue()), "HH:mm:ss SSS");
            }

            public DataType getDataType(int index) {
                return DataTypes.DURATION;
            }

            public double getXStep() {
                Range r = this.getXRange();
                double delta = (Double)r.upperEndpoint() - (Double)r.lowerEndpoint();
                return delta / 5.0;
            }

            public String getTooltip(int index, int item) {
                return DataTypes.DATE.asString((Object)new Date(new Double(this.getXValue(index, item)).longValue()), "HH:mm:ss SSS") + ":    " + DataTypes.DURATION.asString((Object)this.getYValue(index, item));
            }
        }).build();
    }

    private XYDataset[] loadChartData() {
        DataReport report = this.getDefaultReport();
        XYSeries series = new XYSeries((Comparable)((Object)""));
        long max = Long.MIN_VALUE;
        for (DataRow each : report.getRows()) {
            Calendar cal = (Calendar)each.getValue("timestamp");
            series.add((double)cal.getTimeInMillis(), (double)each.getLong("duration"));
            max = Math.max(max, each.getLong("duration"));
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return new XYDataset[]{dataset};
    }

    private void renderTable() {
        SampleTableRenderer tableRenderer = new SampleTableRenderer(this.getRenderer().getCategory());
        tableRenderer.setContentOnly(true);
        tableRenderer.setInDropDown(true);
        tableRenderer.setMode(this.getRenderer().getMode());
        tableRenderer.setDataSource(this.getDataSource());
        this.add(new Component[]{tableRenderer.render("table", this.getDefaultModel())});
    }
}

