/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.jmeter.generator.Sample;
import java.util.Collections;
import java.util.List;

public class UriReport
implements Comparable<UriReport> {
    private final String label;
    private List<Sample> samples = Lists.newArrayList();

    public UriReport(String uri) {
        this.label = uri;
    }

    public String getLabel() {
        return this.label;
    }

    public void addSample(Sample sample) {
        this.samples.add(sample);
    }

    public int countErrors() {
        int nbError = 0;
        for (Sample each : this.samples) {
            if (each.isOk()) continue;
            ++nbError;
        }
        return nbError;
    }

    public double errorPercent() {
        return (double)this.countErrors() / (double)this.size() * 100.0;
    }

    public int size() {
        return this.samples.size();
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (Sample each : this.samples) {
            max = Math.max(max, each.getElapsedTime());
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (Sample each : this.samples) {
            min = Math.min(min, each.getElapsedTime());
        }
        return min;
    }

    public long getAverage() {
        return this.getTotalTime() / (long)this.size();
    }

    public long getTotalTime() {
        long total = 0L;
        for (Sample each : this.samples) {
            total += each.getElapsedTime();
        }
        return total;
    }

    public long get90Line() {
        long result = 0L;
        Collections.sort(this.samples);
        if (this.samples.size() > 0) {
            result = this.samples.get((int)((double)this.samples.size() * 0.9)).getElapsedTime();
        }
        return result;
    }

    public long getMedian() {
        long result = 0L;
        Collections.sort(this.samples);
        if (this.samples.size() > 0) {
            result = this.samples.get((int)((double)this.samples.size() * 0.5)).getElapsedTime();
        }
        return result;
    }

    public double getTotalSizeInKb() {
        double traffic = 0.0;
        for (Sample each : this.samples) {
            traffic += each.getSizeInKb();
        }
        return traffic;
    }

    public int getSampleCount() {
        int count = 0;
        for (Sample each : this.samples) {
            count += each.getSampleCount();
        }
        return count;
    }

    public int getErrorCount() {
        int count = 0;
        for (Sample each : this.samples) {
            count += each.getErrorCount();
        }
        return count;
    }

    @Override
    public int compareTo(UriReport other) {
        if (this == other) {
            return 0;
        }
        return this.label.compareTo(other.label);
    }
}

