/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import java.util.Calendar;
import java.util.Date;

public class Sample
implements Comparable<Sample> {
    private String label;
    private int sampleCount = 1;
    private long elapsedTime;
    private int errorCount = 0;
    private Date timestamp;
    private boolean ok;
    private double sizeInKb;

    public static Sample fromDataRow(DataRow row) {
        Sample sample = new Sample();
        sample.setLabel(row.getValueAsString("label"));
        sample.setElapsedTime(row.getLong("duration"));
        sample.setSampleCount(row.getInt("sampleCount"));
        sample.setErrorCount(row.getInt("errorCount"));
        sample.setSizeInKb(row.getDouble("size"));
        sample.setOk(row.getBoolean("successful"));
        sample.setTimestamp(((Calendar)row.getValue("timestamp")).getTime());
        return sample;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public double getSizeInKb() {
        return this.sizeInKb;
    }

    public void setSizeInKb(double sizeInKb) {
        this.sizeInKb = sizeInKb;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(Sample o) {
        return (int)(this.getElapsedTime() - o.getElapsedTime());
    }
}

