/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.group.GroupProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.jmeter.generator.Sample;
import com.pmease.quickbuild.plugin.report.jmeter.generator.UriReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class RequestGroupProcessor
extends GroupProcessor {
    private static final long serialVersionUID = 1L;

    public RequestGroupProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        if (sourceReport == null) {
            return;
        }
        DataReport destReport = context.getDestReport();
        HashMap uriReports = Maps.newHashMap();
        for (DataRow each : sourceReport.getRows()) {
            String label = each.getString("label");
            UriReport u = (UriReport)uriReports.get(label);
            if (u == null) {
                u = new UriReport(label);
                uriReports.put(label, u);
            }
            Sample sample = Sample.fromDataRow(each);
            u.addSample(sample);
        }
        ArrayList list = Lists.newArrayList(uriReports.values());
        Collections.sort(list);
        for (UriReport each : list) {
            DataRow row = destReport.addRow();
            row.setValue("label", (Object)each.getLabel());
            int sampleCount = each.getSampleCount();
            int errorCount = each.getErrorCount();
            row.setValue("sampleCount", (Object)sampleCount);
            row.setValue("errorCount", (Object)errorCount);
            row.setValue("totalTime", (Object)each.getTotalTime());
            row.setValue("averageTime", (Object)each.getAverage());
            row.setValue("minTime", (Object)each.getMin());
            row.setValue("maxTime", (Object)each.getMax());
            row.setValue("sizeInKb", (Object)each.getTotalSizeInKb());
            row.setValue("line90Time", (Object)each.get90Line());
            row.setValue("medianTime", (Object)each.getMedian());
            row.setValue("successRate", (Object)MathUtils.divide((int)(sampleCount - errorCount), (int)sampleCount));
        }
    }
}

