/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;

public class RequestDuplicateRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public RequestDuplicateRule(ReportCategory category) {
        super(category);
    }

    public void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        long totalTime = destRow.getLong("totalTime");
        int sampleCount = destRow.getInt("sampleCount");
        int errorCount = destRow.getInt("errorCount");
        destRow.setValue("averageTime", (Object)MathUtils.divide((Number)totalTime, (Number)sampleCount));
        destRow.setValue("successRate", (Object)MathUtils.divide((Number)(sampleCount - errorCount), (Number)new Double(sampleCount)));
        destRow.setValue("minTime", (Object)Math.min(destRow.getLong("minTime"), sourceRow.getLong("minTime")));
        destRow.setValue("maxTime", (Object)Math.max(destRow.getLong("maxTime"), sourceRow.getLong("maxTime")));
    }

    protected String[] forColumns() {
        return new String[]{"minTime", "maxTime", "averageTime", "successRate"};
    }
}

