/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.diff.DiffProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.util.HashSet;
import java.util.Map;

public class RequestDiffProcessor
extends DiffProcessor {
    private static final long serialVersionUID = 1L;

    public RequestDiffProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        DataReport destReport = context.getDestReport();
        DataColumn[] diffColumns = this.getDiffColumns(destReport.getMeta());
        Map sourceIndexes = sourceReport.getRowIndexMap(diffColumns);
        HashSet visited = Sets.newHashSet();
        for (DataRow row : destReport.getRows()) {
            String key = row.getRowKeyString(diffColumns);
            Integer i = (Integer)sourceIndexes.get(key);
            DataRow previousRow = null;
            if (i != null && !visited.contains(i)) {
                previousRow = sourceReport.getRow(i.intValue());
                visited.add(i);
            }
            if (previousRow == null) continue;
            row.setValue("averageDiff", (Object)(row.getLong("averageTime") - previousRow.getLong("averageTime")));
            row.setValue("medianDiff", (Object)(row.getLong("medianTime") - previousRow.getLong("medianTime")));
            row.setValue("sizeDiff", (Object)(row.getDouble("sizeInKb") - previousRow.getDouble("sizeInKb")));
        }
    }
}

