/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.jmeter.generator.JtlXMLParser;
import com.pmease.quickbuild.plugin.report.jmeter.generator.UriReport;
import java.util.List;
import org.dom4j.Document;

public class JtlXMLProcessor
extends XPathProcessor {
    public JtlXMLProcessor(ReportCategory category) {
        super(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(GeneratorResource resource) {
        ResourceReader reader = this.createReader();
        if (reader == null) {
            return;
        }
        GeneratorContext context = GeneratorContext.getContext();
        context.setResource((Object)resource);
        try {
            Document doc = (Document)reader.read();
            List<UriReport> aggregates = JtlXMLParser.parse(doc);
            DataReport report = GeneratorContext.getContext().getDestReport();
            for (UriReport each : aggregates) {
                DataRow row = report.addRow();
                row.setValue("label", (Object)each.getLabel());
                int sampleCount = each.getSampleCount();
                int errorCount = each.getErrorCount();
                row.setValue("sampleCount", (Object)sampleCount);
                row.setValue("errorCount", (Object)errorCount);
                row.setValue("totalTime", (Object)each.getTotalTime());
                row.setValue("minTime", (Object)each.getMin());
                row.setValue("maxTime", (Object)each.getMax());
                row.setValue("averageTime", (Object)each.getAverage());
                row.setValue("successRate", (Object)MathUtils.divide((int)(sampleCount - errorCount), (int)sampleCount));
                row.setValue("line90Time", (Object)each.get90Line());
                row.setValue("medianTime", (Object)each.getMedian());
                row.setValue("sizeInKb", (Object)each.getTotalSizeInKb());
            }
        }
        finally {
            reader.close();
        }
    }
}

