/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.jmeter.generator.Sample;
import com.pmease.quickbuild.plugin.report.jmeter.generator.UriReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class JtlXMLParser {
    public static List<Sample> readSamples(Document doc) {
        ArrayList samples = Lists.newArrayList();
        for (Object each : doc.getRootElement().elements()) {
            Element e = (Element)each;
            Sample sample = JtlXMLParser.parseSample(e);
            samples.add(sample);
        }
        return samples;
    }

    public static List<UriReport> parse(Document doc) {
        List<Sample> samples = JtlXMLParser.readSamples(doc);
        HashMap map = Maps.newHashMap();
        for (Sample each : samples) {
            UriReport aggregate = (UriReport)map.get(each.getLabel());
            if (aggregate == null) {
                aggregate = new UriReport(each.getLabel());
                map.put(each.getLabel(), aggregate);
            }
            aggregate.addSample(each);
        }
        ArrayList result = Lists.newArrayList(map.values());
        Collections.sort(result);
        return result;
    }

    private static Sample parseSample(Element e) {
        Sample sample = new Sample();
        sample.setLabel(e.attributeValue("lb"));
        int count = XMLHelper.getInt((Node)e, (String)"./@sc", (Integer)1);
        sample.setSampleCount(count);
        boolean ok = XMLHelper.getBoolean((Node)e, (String)"./@s", (Boolean)Boolean.FALSE);
        sample.setOk(ok);
        count = XMLHelper.getInt((Node)e, (String)"./@ec", (Integer)0);
        if (count == 0 && !ok) {
            count = 1;
        }
        sample.setErrorCount(count);
        sample.setElapsedTime(XMLHelper.getLong((Node)e, (String)"./@t", (Long)0L));
        sample.setSizeInKb(XMLHelper.getDouble((Node)e, (String)"./@by", (Double)0.0));
        sample.setTimestamp(new Date(XMLHelper.getLong((Node)e, (String)"./@ts", (Long)0L)));
        return sample;
    }
}

