/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.List;

public class HistoryRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public HistoryRule(ReportCategory category) {
        super(category);
    }

    protected void doExecute() {
        GeneratorContext context = this.getContext();
        Long buildId = context.getCurrentBuild().getId();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        destRow.setValue("lastRunBuild", (Object)buildId);
        destRow.setValue("label", sourceRow.getValue("label"));
        destRow.setValue("lastRunBuilds", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("lastRunBuilds")), (Object)buildId));
        destRow.setValue("sampleCounts", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("sampleCounts")), (Object)sourceRow.getValue("sampleCount")));
        destRow.setValue("errorCounts", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("errorCounts")), (Object)sourceRow.getValue("errorCount")));
        destRow.setValue("successRates", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("successRates")), (Object)sourceRow.getValue("successRate")));
        destRow.setValue("totalTimes", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("totalTimes")), (Object)sourceRow.getValue("totalTime")));
        destRow.setValue("averageTimes", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("averageTimes")), (Object)sourceRow.getValue("averageTime")));
        destRow.setValue("minTimes", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("minTimes")), (Object)sourceRow.getValue("minTime")));
        destRow.setValue("maxTimes", (Object)ReportUtils.limitAddingValue((List)((List)destRow.getValue("maxTimes")), (Object)sourceRow.getValue("maxTime")));
        List maxTimesList = (List)destRow.getValue("maxTimes");
        List medianTimesList = (List)destRow.getValue("medianTimes");
        for (int i = 0; i < maxTimesList.size() - 1 - medianTimesList.size(); ++i) {
            medianTimesList.add(0L);
        }
        medianTimesList.add((Long)sourceRow.getValue("medianTime"));
        destRow.setValue("medianTimes", (Object)medianTimesList);
        List line90TimesList = (List)destRow.getValue("line90Times");
        for (int i = 0; i < maxTimesList.size() - 1 - line90TimesList.size(); ++i) {
            line90TimesList.add(0L);
        }
        line90TimesList.add((Long)sourceRow.getValue("line90Time"));
        destRow.setValue("line90Times", (Object)line90TimesList);
    }

    protected String[] forColumns() {
        return new String[]{"lastRunBuild", "lastRunBuilds", "sampleCounts", "errorCounts", "successRates", "totalTimes", "averageTimes", "minTimes", "maxTimes", "medianTimes", "line90Times"};
    }
}

