/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.jmeter.JMeterPlugin;
import com.pmease.quickbuild.plugin.report.jmeter.renderer.JMeterStatsRenderer;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="JMeter Stats", category={"Performance Test Statistics"})
public class JMeterStatsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;

    protected StatisticsRenderer createRenderer() {
        ReportCategory category = ReportHelper.getCategory(JMeterPlugin.class);
        JMeterStatsRenderer r = new JMeterStatsRenderer(category);
        r.setSimpleMode(true);
        return r;
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Success Rate", "Average Time", "Min Time", "Max Time"});
    }
}

