/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.jmeter.JMeterPlugin;

@Editable(name="JMeter Report")
public class JMeterAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(JMeterPlugin.class);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        int sampleCount = destRow.getInt("sampleCount") + sourceRow.getInt("sampleCount");
        int errorCount = destRow.getInt("errorCount") + sourceRow.getInt("errorCount");
        destRow.setValue("sampleCount", (Object)sampleCount);
        destRow.setValue("errorCount", (Object)errorCount);
        destRow.setValue("successRate", (Object)(sampleCount == 0 ? 0.0 : (double)(sampleCount - errorCount) / new Double(sampleCount)));
        long totalTime = destRow.getLong("totalTime") + sourceRow.getLong("totalTime");
        destRow.setValue("totalTime", (Object)totalTime);
        destRow.setValue("averageTime", (Object)(totalTime / (long)sampleCount));
        if (destRow.getNullableValue("minTime") == null) {
            destRow.setValue("minTime", (Object)sourceRow.getLong("minTime"));
        } else {
            destRow.setValue("minTime", (Object)Math.min(destRow.getLong("minTime"), sourceRow.getLong("minTime")));
        }
        destRow.setValue("maxTime", (Object)Math.max(destRow.getLong("maxTime"), sourceRow.getLong("maxTime")));
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        int sampleCount = destRow.getInt("sampleCount");
        int errorCount = destRow.getInt("errorCount");
        destRow.setValue("successRate", (Object)(sampleCount == 0 ? 0.0 : (double)(sampleCount - errorCount) / new Double(sampleCount)));
        long totalTime = destRow.getLong("totalTime");
        destRow.setValue("averageTime", (Object)(totalTime / (long)sampleCount));
    }
}

