/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.jmeter;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.jmeter.JMeterPlugin;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;

@Editable(category={"Publish"}, name="JMeter Report", description="Publish JMeter XML reports")
@ScriptApi(value="This step publishes the original JMeter performance XML files.")
public class JMeterPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private double successRate;
    @XStreamOmitField
    private int sampleCount;
    @XStreamOmitField
    private int errorCount;
    @XStreamOmitField
    private long averageTime;
    @XStreamOmitField
    private long minTime;
    @XStreamOmitField
    private long maxTime;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(JMeterPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "JMeterPublisher::saveStatsReport");
            Map map = category.getDefaultStats(db, "requests", new Filter[0]);
            DataRow row = statsReport.addRow();
            row.fromMap(map);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            this.sampleCount = MapUtils.getIntValue((Map)map, (Object)"sampleCount");
            this.errorCount = MapUtils.getIntValue((Map)map, (Object)"errorCount");
            this.successRate = this.sampleCount == 0 ? 0.0 : (double)(this.sampleCount - this.errorCount) / new Double(this.sampleCount);
            long totalTime = MapUtils.getLongValue((Map)map, (Object)"totalTime");
            this.averageTime = this.sampleCount == 0 ? 0L : totalTime / (long)this.sampleCount;
            this.minTime = MapUtils.getLongValue((Map)map, (Object)"minTime");
            this.maxTime = MapUtils.getLongValue((Map)map, (Object)"maxTime");
            row.setValue("sampleCount", (Object)this.sampleCount);
            row.setValue("errorCount", (Object)this.errorCount);
            row.setValue("successRate", (Object)this.successRate);
            row.setValue("averageTime", (Object)this.averageTime);
            row.setValue("totalTime", (Object)totalTime);
            row.setValue("minTime", (Object)this.minTime);
            row.setValue("maxTime", (Object)this.maxTime);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @ScriptApi
    public double getSuccessRate() {
        return this.successRate;
    }

    public void setSuccessRate(double successRate) {
        this.successRate = successRate;
    }

    @ScriptApi
    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    @ScriptApi
    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    @ScriptApi
    public long getAverageTime() {
        return this.averageTime;
    }

    public void setAverageTime(long averageTime) {
        this.averageTime = averageTime;
    }

    @ScriptApi
    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    @ScriptApi
    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"successRate");
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"sampleCount");
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"errorCount");
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"averageTime");
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"minTime");
        JMeterPublisher.removeElement((VersionedDocument)dom, (String)"maxTime");
    }
}

