/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.accurev;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevRepository;
import com.pmease.quickbuild.plugin.scm.accurev.WorkspaceNameProvider;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.springframework.util.StringUtils;

@Editable(name="Auto-generated safe name based on node and root directory", order=100)
public class NodeAndDirBasedWorkspaceName
implements WorkspaceNameProvider {
    private static final long serialVersionUID = 1L;
    private AccurevRepository repository;
    private transient String workspaceName;

    public NodeAndDirBasedWorkspaceName(AccurevRepository repository) {
        this.repository = repository;
    }

    @ScriptApi(value="Get associated repository object.")
    public AccurevRepository getRepository() {
        return this.repository;
    }

    @Override
    @ScriptApi(value="Get name of the workspace.")
    public String getWorkspaceName() {
        if (this.workspaceName == null) {
            GridNode node = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
            this.workspaceName = "qb-" + node.getHostName() + "-" + FileUtils.assignIdFor((File)this.repository.getLocationDir());
            this.workspaceName = StringUtils.replace((String)this.workspaceName, (String)" ", (String)"_");
        }
        return this.workspaceName;
    }
}

