/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.accurev;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Global setting for Accurev.")
public class AccurevSetting {
    private String accurevExecutablePath;
    private String replicaSyncCondition = "false";

    @Editable(order=100, description="Specify path to Accurev executable. For example: <b>/usr/local/bin/accurev</b>")
    @ScriptApi(value="Get Accurev executable path. Null if not specified.")
    @Scriptable
    public String getAccurevExecutablePath() {
        return this.accurevExecutablePath;
    }

    public void setAccurevExecutablePath(String accurevExecutablePath) {
        this.accurevExecutablePath = accurevExecutablePath;
    }

    @Editable(order=200, description="If this condition is satisfied, QuickBuild will sync the replica before running a configuration to ensure the local Accurev server has latest files.")
    @Expressions(value={"sync always", "true", "never sync", "false"})
    @NotEmpty
    @ScriptApi(value="Get replica sync condition.")
    @Scriptable
    public String getReplicaSyncCondition() {
        return this.replicaSyncCondition;
    }

    public void setReplicaSyncCondition(String replicaSyncCondition) {
        this.replicaSyncCondition = replicaSyncCondition;
    }
}

