/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.accurev;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.IdManager;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevPlugin;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevRevision;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevSetting;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.accurev.NodeAndDirBasedWorkspaceName;
import com.pmease.quickbuild.plugin.scm.accurev.Stream;
import com.pmease.quickbuild.plugin.scm.accurev.Transaction;
import com.pmease.quickbuild.plugin.scm.accurev.Workspace;
import com.pmease.quickbuild.plugin.scm.accurev.WorkspaceNameProvider;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Editable(name="Accurev", description="Configure a Accurev repository here. By default, QuickBuild executes \"accurev\" to checkout from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Accurev plugin through the plugin management page.")
@ScriptApi
public class AccurevRepository
extends Repository<AccurevRevision> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");
    private String server;
    private String streamName;
    private String additionalChangeDetectionStreams;
    private String transactionNumber;
    private WorkspaceNameProvider workspaceNameProvider = new NodeAndDirBasedWorkspaceName(this);
    private String locationPath;
    private String userName;
    private String password;
    private List<Property> environments = new ArrayList<Property>();
    private AccurevProofBuildSupport proofBuildSupport;
    private transient Boolean supportLogin;
    @XStreamOmitField
    private Map<String, Stream> streamCache;
    @XStreamOmitField
    private Set<String> workspaceNos;
    @XStreamOmitField
    private Map<String, Workspace> workspaceCache;

    @Editable(order=90, name="Accurev Server", description="Specify Accurev server in the form of <b>&lt;server&gt;:&lt;port&gt;</b>, for example, <b>myservername:5050</b>.")
    @NotEmpty
    @ScriptApi(value="Get server address.")
    @Scriptable
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Editable(order=100, name="Build Stream", description="Specify the stream to build against. You can also specify a snapshot name here to build against a particular snapshot. In this case, various properties specified below such as <b>Transaction Number</b>, <b>Checkout Workspace</b> will be ignored.<br><b>NOTE: </b>You can not specify build stream as a Accurev workspace here.")
    @NotEmpty
    @ScriptApi(value="Get stream name to build against.")
    @Scriptable
    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    @Editable(order=100, name="Additional Change Detection Streams", description="Specify additional streams to detect changes besides the build stream. If not specified, changes will be detected from all ancestors of the build stream. Multiple streams need to be separated by comma.")
    @Scriptable
    @ScriptApi(value="Get change detection streams")
    public String getAdditionalChangeDetectionStreams() {
        return this.additionalChangeDetectionStreams;
    }

    public void setAdditionalChangeDetectionStreams(String additionalChangeDetectionStreams) {
        this.additionalChangeDetectionStreams = additionalChangeDetectionStreams;
    }

    @Editable(order=200, name="Transaction Number", description="Specify transaction number to build against. Leave it empty if you want to build against latest transaction of the stream.")
    @Scriptable
    @Numeric
    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    @ScriptApi(value="Get revision of the repository.")
    public AccurevRevision getRevision() {
        return (AccurevRevision)super.getRevision();
    }

    @Editable(name="Checkout Workspace Name", order=300, description="Specify name of the workspace which will be created by QuickBuild to check out code for the build.")
    @NotNull
    @ScriptApi(value="Get checkout workspace name provider.")
    public WorkspaceNameProvider getWorkspaceNameProvider() {
        return this.workspaceNameProvider;
    }

    public void setWorkspaceNameProvider(WorkspaceNameProvider workspaceNameProvider) {
        this.workspaceNameProvider = workspaceNameProvider;
    }

    @ScriptApi(value="Get name of the workspace to be used for checkout.")
    public String getWorkspaceName() {
        return this.getWorkspaceNameProvider().getWorkspaceName();
    }

    @Editable(order=400, name="Location Directory", description="Optionally specify a path relative to the configuration workspace (NOT the Accurev workspace) which will be used as physical location for the Accurev checkout workspace created above. If left empty, the configuration workspace itself will be used as physical location directory.")
    @ScriptApi(value="Get path of location directory of the Accurev checkout workspace (relative to the configuration workspace directory). Null will be returned if the configuration workspace directory is used.")
    @Scriptable
    public String getLocationPath() {
        return this.locationPath;
    }

    public void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
    }

    @Editable(order=500, name="User", description="Specify the user to login to Accurev server.")
    @NotEmpty
    @ScriptApi(value="Get user name to login to Accurev server.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=600, name="Password", description="Specify password for above user.")
    @Password
    @ScriptApi(value="Get password to login to Accurev server. Null if no password specified.")
    @Scriptable
    @NotEmpty
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(name="Environment Variables", order=1200, description="Specify environment variables when executing various accurev commands.")
    @ScriptApi(value="Get defined environment variables when executing various accurev commands.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @Editable(order=1300, description="Check this to enable proof build for this repository. Use this approach to verify active workspace changes before promoting.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public AccurevProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(AccurevProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    public File getLocationDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getLocationPath());
    }

    private AccurevSetting getAccurevSetting() {
        return (AccurevSetting)PluginSettingHelper.getSetting(AccurevPlugin.class, (boolean)true);
    }

    Commandline buildAccurevCmd(String command) {
        Commandline cmdline = new Commandline();
        String accurevExe = this.getAccurevSetting().getAccurevExecutablePath();
        if (accurevExe == null) {
            accurevExe = "accurev";
        }
        cmdline.setExecutable(accurevExe);
        if (command != null) {
            cmdline.createArgument().setValue(command);
            if (this.getServer() != null) {
                cmdline.createArgument().setValue("-H");
                cmdline.createArgument().setValue(this.getServer());
            }
        }
        return cmdline;
    }

    private boolean isSupportLogin() {
        if (this.supportLogin == null) {
            this.supportLogin = false;
            Commandline cmdline = this.buildAccurevCmd(null);
            cmdline.createArgument().setLine("help security");
            Context.getLogger().info("Checking login support...");
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (line.startsWith("accurev login") || line.startsWith("LOGIN")) {
                        AccurevRepository.this.supportLogin = true;
                    }
                }
            }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        }
        return this.supportLogin;
    }

    File createAuthDir(final String userName, final String password) {
        File homeDir = FileUtils.createTempDir((String)"accurevauth");
        try {
            if (this.isSupportLogin()) {
                Commandline cmdline = this.buildAccurevCmd("login");
                cmdline.setSecretMasker(new SecretMasker(){

                    public String mask(String message) {
                        if (password != null) {
                            return StringUtils.replace((String)message, (String)(this.quoteIfNecessary(userName) + " " + this.quoteIfNecessary(password)), (String)(this.quoteIfNecessary(userName) + " ******"));
                        }
                        return message;
                    }
                });
                cmdline.addArgValue(userName);
                if (password != null) {
                    cmdline.addArgValue(password);
                } else {
                    cmdline.addArgValue("\"\"");
                }
                Context.getLogger().info("Generating session/auth file...");
                Environment env = new Environment();
                Environment.Variable var = new Environment.Variable();
                var.setKey("ACCUREV_HOME");
                var.setValue(homeDir.getAbsolutePath());
                env.addVariable(var);
                var = new Environment.Variable();
                var.setKey("ACCUREV_PRINCIPAL");
                var.setValue(userName);
                env.addVariable(var);
                cmdline.execute(env, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            } else {
                File accurevDir = new File(homeDir, ".accurev");
                FileUtils.createDir((File)accurevDir);
                FileUtils.writeFile((File)new File(accurevDir, "authn"), (String)(password != null ? password : ""));
            }
            return homeDir;
        }
        catch (Exception e) {
            FileUtils.deleteDir((File)homeDir);
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    Environment createAuthEnv(File authDir, String userName, String password) {
        Environment env = new Environment();
        Environment.Variable var = new Environment.Variable();
        var.setKey("ACCUREV_HOME");
        var.setValue(authDir.getAbsolutePath());
        env.addVariable(var);
        var = new Environment.Variable();
        var.setKey("ACCUREV_PRINCIPAL");
        var.setValue(userName);
        env.addVariable(var);
        if (SystemUtils.IS_OS_WINDOWS) {
            var = new Environment.Variable();
            var.setKey("HOMEDRIVE");
            var.setValue(StringUtils.substringBefore((String)authDir.getAbsolutePath(), (String)":") + ":");
            env.addVariable(var);
            var = new Environment.Variable();
            var.setKey("HOMEPATH");
            var.setValue(StringUtils.substringAfter((String)authDir.getAbsolutePath(), (String)":"));
            env.addVariable(var);
        } else {
            var = new Environment.Variable();
            var.setKey("HOME");
            var.setValue(authDir.getAbsolutePath());
            env.addVariable(var);
        }
        for (Property each : this.getEnvironments()) {
            var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void populateStream(Environment authEnv, String streamName) {
        Context.getLogger().info("Populating directory '" + this.getLocationDir().getAbsolutePath() + "' from stream '" + streamName + "'...");
        File tempDir = null;
        try {
            Workspace workspace = this.getWorkspace(authEnv, null);
            if (workspace != null && FilenameUtils.equalsNormalizedOnSystem((String)workspace.getLocation(), (String)this.getLocationDir().getAbsolutePath())) {
                tempDir = FileUtils.createTempDir((String)"accurevpopstream");
                Context.getLogger().warn("Location directory is occupied by workspace '" + this.getWorkspaceName() + "', relocating to '" + tempDir.getAbsolutePath() + "' temporarily.");
                this.relocateWorkspace(authEnv, tempDir);
            }
            Commandline cmdline = this.buildAccurevCmd("pop");
            cmdline.createArgument().setValue("-O");
            cmdline.createArgument().setValue("-R");
            cmdline.createArgument().setValue("-v");
            cmdline.createArgument().setValue(streamName);
            cmdline.createArgument().setValue("-L");
            cmdline.createArgument().setValue(this.getLocationDir().getAbsolutePath());
            cmdline.createArgument().setValue(".");
            cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (tempDir == null) return;
        }
        catch (Throwable throwable) {
            if (tempDir == null) throw throwable;
            try {
                this.relocateWorkspace(authEnv, this.getLocationDir());
                throw throwable;
            }
            finally {
                FileUtils.deleteDir(tempDir);
            }
        }
        try {
            this.relocateWorkspace(authEnv, this.getLocationDir());
            return;
        }
        finally {
            FileUtils.deleteDir((File)tempDir);
        }
    }

    private void populateWorkspace(Environment authEnv) {
        Context.getLogger().info("Populating directory '" + this.getLocationDir().getAbsolutePath() + "' from workspace '" + this.getWorkspaceName() + "'...");
        Commandline cmdline = this.buildAccurevCmd("pop");
        cmdline.createArgument().setLine("-O -R .");
        cmdline.execute(this.getLocationDir(), authEnv, (OutputStream)new LineConsumer.WarnLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    String getHelperStreamName() {
        GridNode node = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
        return "qb.helper." + this.getStreamName() + "." + node.getHostName() + "." + ((IdManager)Quickbuild.getInstance(IdManager.class)).getId(this.getLocationDir().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkoutByRevision(AccurevRevision revision) {
        File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
        try {
            File revisionFile = new File(this.getLocationDir(), this.getName() + ".revision");
            Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
            this.createWorkspaceIfNecessary(authEnv);
            Stream stream = this.getStreamByName(authEnv, this.getStreamName());
            if (stream.getType() == Stream.Type.normal || stream.getType() == Stream.Type.passthrough) {
                Workspace workspace = this.getWorkspace(authEnv, null);
                Validate.notNull((Object)workspace);
                String helperStreamName = this.getHelperStreamName();
                Lock helperStreamLock = LockUtils.lock((String)("accurev:stream:" + helperStreamName));
                try {
                    Stream helperStream = this.getStreamByName(authEnv, helperStreamName);
                    if (helperStream != null) {
                        if (helperStream.isHidden()) {
                            this.reactivateStream(authEnv, helperStreamName);
                        }
                        this.changeHelperStream(authEnv, helperStreamName, revision.getValue());
                    } else {
                        this.createHelperStream(authEnv, helperStreamName, this.getStreamName(), revision.getValue());
                    }
                    this.changeWorkspace(authEnv, this.getWorkspaceName(), helperStreamName);
                    if (!revisionFile.exists()) {
                        this.populateWorkspace(authEnv);
                    }
                    this.updateWorkspace(authEnv, 0L);
                    this.deactivateStream(authEnv, helperStreamName);
                }
                finally {
                    helperStreamLock.unlock();
                }
            } else {
                Context.getLogger().info("Cleaning directory '" + this.getLocationDir().getAbsolutePath() + "' before populating from a snapshot...");
                FileUtils.cleanDir((File)this.getLocationDir());
                this.populateStream(authEnv, this.getStreamName());
            }
            FileUtils.writeFile((File)revisionFile, (String)revision.toString());
        }
        finally {
            this.removeAuthDir(authDir, this.userName);
        }
    }

    void removeAuthDir(File authDir, String userName) {
        if (this.isSupportLogin()) {
            Commandline cmdline = this.buildAccurevCmd("logout");
            Environment env = new Environment();
            Environment.Variable var = new Environment.Variable();
            var.setKey("ACCUREV_HOME");
            var.setValue(authDir.getAbsolutePath());
            env.addVariable(var);
            var = new Environment.Variable();
            var.setKey("ACCUREV_PRINCIPAL");
            var.setValue(userName);
            env.addVariable(var);
            cmdline.execute(env, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        }
        FileUtils.deleteDir((File)authDir);
    }

    private void createWorkspaceIfNecessary(Environment authEnv) {
        Stream stream = this.getStreamByName(authEnv, this.getStreamName());
        if (stream.getType() == Stream.Type.normal || stream.getType() == Stream.Type.passthrough) {
            Workspace workspace = this.getWorkspace(authEnv, null);
            if (workspace != null) {
                if (workspace.isHidden()) {
                    this.reactivateWorkspace(authEnv);
                }
                if (!workspace.getDepotName().equals(stream.getDepotName()) || workspace.getStreamNo() != stream.getNumber()) {
                    this.changeWorkspace(authEnv, this.getWorkspaceName(), this.getStreamName());
                }
                if (!FilenameUtils.equalsNormalizedOnSystem((String)workspace.getLocation(), (String)this.getLocationDir().getAbsolutePath())) {
                    FileUtils.createDir((File)this.getLocationDir());
                    this.relocateWorkspace(authEnv, this.getLocationDir());
                }
            } else {
                Context.getLogger().info("Creating checkout workspace '" + this.getWorkspaceName() + "'...");
                Commandline cmdline = this.buildAccurevCmd("mkws").addArgValue("-w").addArgValue(this.getWorkspaceName()).addArgValue("-b").addArgValue(this.getStreamName()).addArgValue("-l").addArgValue(this.getLocationDir().getAbsolutePath());
                cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        if (line.startsWith("Invalid stream name") || line.startsWith("non-digit other than") || line.startsWith("characters '\\' or '/'")) {
                            Context.getLogger().error(line);
                        } else {
                            Context.getLogger().info(line);
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                Context.getLogger().info("Cleaning directory '" + this.getLocationDir().getAbsolutePath() + "' before updating from workspace...");
                FileUtils.cleanDir((File)this.getLocationDir());
                this.updateWorkspace(authEnv, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Changeset> getChangesBetween(AccurevRevision startRevision, AccurevRevision endRevision) {
        File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
        try {
            Document responseDoc;
            ArrayList<Changeset> changesets = new ArrayList<Changeset>();
            if (startRevision.getValue() >= endRevision.getValue()) {
                ArrayList<Changeset> arrayList = changesets;
                return arrayList;
            }
            ArrayList<Stream> streams = new ArrayList<Stream>();
            Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
            Stream stream = this.getStreamByName(authEnv, this.getStreamName());
            if (stream == null) {
                throw new QuickbuildException("Can not find stream named by '" + this.getStreamName() + "'.");
            }
            streams.add(stream);
            HashSet<String> ignoreFromStreams = new HashSet<String>();
            ignoreFromStreams.add(stream.getName());
            String additionalChangeDetectionStreams = this.getAdditionalChangeDetectionStreams();
            if (additionalChangeDetectionStreams != null) {
                for (String name : StringUtils.splitAndTrim((String)this.getAdditionalChangeDetectionStreams())) {
                    stream = this.getStreamByName(authEnv, name);
                    if (stream == null) {
                        throw new QuickbuildException("Can not find stream named by '" + name + "'.");
                    }
                    streams.add(stream);
                }
            }
            String backStreamName = stream.getBackStreamName();
            while (stream.getDate() == null && backStreamName != null) {
                stream = this.getStreamByName(authEnv, backStreamName);
                if (stream == null) {
                    throw new QuickbuildException("Can not find stream named by '" + backStreamName + "'.");
                }
                ignoreFromStreams.add(backStreamName);
                if (additionalChangeDetectionStreams == null) {
                    streams.add(stream);
                }
                backStreamName = stream.getBackStreamName();
            }
            HashSet<Modification> modifications = new HashSet<Modification>();
            for (Stream each : streams) {
                Commandline cmdLine = this.buildAccurevCmd("hist");
                cmdLine.createArgument().setLine("-a -s");
                cmdLine.createArgument().setValue(each.getName());
                cmdLine.createArgument().setLine("-t " + (Object)((Object)endRevision) + "-" + (Object)((Object)startRevision));
                cmdLine.createArgument().setValue("-fex");
                Document doc = this.buildResponseDoc(cmdLine, null, authEnv, null);
                if (doc == null) continue;
                for (Element transaction : doc.getRootElement().elements("transaction")) {
                    String fromStreamName;
                    Long transactionNo = Long.valueOf(transaction.attributeValue("id"));
                    if (startRevision.getValue().equals(transactionNo) || (fromStreamName = transaction.attributeValue("fromStreamName")) != null && ignoreFromStreams.contains(fromStreamName)) continue;
                    Changeset changeset = new Changeset();
                    changeset.setId(transactionNo.toString());
                    changeset.setUser(transaction.attributeValue("user"));
                    changeset.setDate(new Date(Long.parseLong(transaction.attributeValue("time")) * 1000L));
                    changeset.setComment(transaction.elementText("comment"));
                    String transType = transaction.attributeValue("type");
                    if (transType.equals("promote")) {
                        Iterator it = transaction.elementIterator("version");
                        while (it.hasNext()) {
                            Element version = (Element)it.next();
                            Attribute pathAttr = version.attribute("path");
                            if (pathAttr == null) continue;
                            Modification modification = new Modification();
                            modification.setPath(StringUtils.stripStart((String)StringUtils.replace((String)pathAttr.getValue(), (String)"\\", (String)"/"), (String)"/."));
                            String pathType = version.attributeValue("elem_type");
                            if ("text".equals(pathType)) {
                                modification.setPathType(Modification.PathType.TEXT);
                            } else if ("binary".equals(pathType)) {
                                modification.setPathType(Modification.PathType.BINARY);
                            } else if ("dir".equals(pathType)) {
                                modification.setPathType(Modification.PathType.DIR);
                            }
                            Validate.isTrue((boolean)it.hasNext());
                            version = (Element)it.next();
                            Validate.isTrue((version.attribute("path") == null ? 1 : 0) != 0);
                            modification.setEdition(version.attributeValue("realNamedVersion"));
                            modification.setPreviousEdition(version.attributeValue("ancestorNamedVersion"));
                            if (modification.getPreviousEdition() != null) {
                                modification.setAction(Modification.Action.MODIFY);
                            } else {
                                modification.setAction(Modification.Action.ADD);
                            }
                            if (modifications.contains(modification)) continue;
                            modifications.add(modification);
                            changeset.getModifications().add(modification);
                        }
                        if (changeset.getModifications().isEmpty()) continue;
                        changesets.add(changeset);
                        continue;
                    }
                    if (!transType.equals("defcomp")) continue;
                    changeset.setComment("Include/Exclude rule has been changed.");
                    changesets.add(changeset);
                }
            }
            Commandline cmdLine = this.buildAccurevCmd("diff");
            cmdLine.createArgument().setLine("-a -i -v");
            cmdLine.createArgument().setValue(this.getStreamName());
            cmdLine.createArgument().setValue("-V");
            cmdLine.createArgument().setValue(this.getStreamName());
            cmdLine.createArgument().setLine("-t " + (Object)((Object)endRevision) + "-" + (Object)((Object)startRevision));
            cmdLine.createArgument().setValue("-fex");
            try {
                SAXReader saxReader = new SAXReader(false);
                final StringBuffer buffer = new StringBuffer();
                Commandline.ExecuteResult result = cmdLine.execute(authEnv, (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().debug(line);
                        buffer.append(line.trim() + "\n");
                    }
                }, (LineConsumer)new LineConsumer.WarnLogger());
                if (result.getReturnCode() == 2) {
                    throw result.buildException();
                }
                if (buffer.length() > 10000000) {
                    Context.getLogger().warn("Can not parse XML as it is too large.");
                    responseDoc = null;
                } else {
                    responseDoc = saxReader.read((Reader)new StringReader(buffer.toString()));
                }
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            if (responseDoc != null) {
                HashSet<String> changedFiles = new HashSet<String>();
                for (Element element : responseDoc.getRootElement().elements("Element")) {
                    for (Element changeElement : element.elements()) {
                        for (Element streamElement : changeElement.elements()) {
                            changedFiles.add(StringUtils.stripStart((String)StringUtils.replace((String)streamElement.attributeValue("Name"), (String)"\\", (String)"/"), (String)"/."));
                        }
                    }
                }
                Iterator itChange = changesets.iterator();
                while (itChange.hasNext()) {
                    Changeset changeset = (Changeset)itChange.next();
                    if (changeset.getModifications().isEmpty()) continue;
                    Iterator itMod = changeset.getModifications().iterator();
                    while (itMod.hasNext()) {
                        if (changedFiles.contains(((Modification)itMod.next()).getPath())) continue;
                        itMod.remove();
                    }
                    if (!changeset.getModifications().isEmpty()) continue;
                    itChange.remove();
                }
            }
            ArrayList<Changeset> arrayList = changesets;
            return arrayList;
        }
        finally {
            this.removeAuthDir(authDir, this.getUserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccurevRevision getHeadRevision() {
        if (this.getTransactionNumber() != null) {
            File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
            try {
                Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
                this.createWorkspaceIfNecessary(authEnv);
            }
            finally {
                this.removeAuthDir(authDir, this.getUserName());
            }
            return new AccurevRevision(Long.valueOf(this.getTransactionNumber()));
        }
        File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
        try {
            Stream stream;
            Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
            Boolean syncReplica = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getAccurevSetting().getReplicaSyncCondition(), Context.buildEvalContext((Object)((Object)this), null));
            if (syncReplica.booleanValue()) {
                Commandline cmdline = this.buildAccurevCmd("replica");
                cmdline.createArgument().setValue("sync");
                cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
            if ((stream = this.getStreamByName(authEnv, this.getStreamName())) == null) {
                throw new QuickbuildException("Can not find stream by name '" + this.getStreamName() + "'.");
            }
            this.createWorkspaceIfNecessary(authEnv);
            AccurevRevision accurevRevision = new AccurevRevision(this.getTransactionByName(authEnv, stream.getDepotName(), "highest").getNumber());
            return accurevRevision;
        }
        finally {
            this.removeAuthDir(authDir, this.getUserName());
        }
    }

    private void createSnapshot(Environment authEnv, String snapshotName, String streamName, String timeSpec) {
        Context.getLogger().info("Creating snapshot '" + snapshotName + "'...");
        Commandline cmdline = this.buildAccurevCmd("mksnap").addArgValue("-s").addArgValue(snapshotName).addArgValue("-b").addArgValue(streamName).addArgValue("-t").addArgValue(timeSpec);
        cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("Invalid stream name") || line.startsWith("non-digit other than") || line.startsWith("characters '\\' or '/'")) {
                    Context.getLogger().error(line);
                } else {
                    Context.getLogger().info(line);
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
    }

    void createHelperStream(Environment authEnv, String streamName, String backStreamName, Long transactionNo) {
        Context.getLogger().info("Creating helper stream '" + streamName + "'...");
        Commandline cmdline = this.buildAccurevCmd("mkstream").addArgValue("-s").addArgValue(streamName).addArgValue("-b").addArgValue(backStreamName).addArgValue("-t").addArgValue(String.valueOf(transactionNo));
        cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("Invalid stream name") || line.startsWith("non-digit other than") || line.startsWith("characters '\\' or '/'")) {
                    Context.getLogger().error(line);
                } else {
                    Context.getLogger().info(line);
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
    }

    void changeHelperStream(Environment authEnv, String streamName, Long transactionNo) {
        Context.getLogger().info("Changing helper stream '" + streamName + "'...");
        Commandline cmdline = this.buildAccurevCmd("chstream").addArgValue("-s").addArgValue(streamName).addArgValue("-t").addArgValue(String.valueOf(transactionNo));
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    void changeWorkspace(Environment authEnv, String workspaceName, String backStreamName) {
        Context.getLogger().info("Changing workspace '" + workspaceName + "'...");
        Commandline cmdline = this.buildAccurevCmd("chws").addArgValue("-w").addArgValue(workspaceName).addArgValue("-b").addArgValue(backStreamName);
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    private void updateWorkspace(Environment authEnv, Long transaction) {
        Context.getLogger().info("Updating workspace '" + this.getWorkspaceName() + "'...");
        Commandline cmdline = this.buildAccurevCmd("update");
        if (transaction != 0L) {
            cmdline.addArgLine("-t " + transaction);
        }
        cmdline.execute(this.getLocationDir(), authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    private void reactivateWorkspace(Environment authEnv) {
        Context.getLogger().info("Reactivating workspace '" + this.getWorkspaceName() + "'...");
        Commandline cmdline = this.buildAccurevCmd("reactivate").addArgValue("wspace").addArgValue(this.getWorkspaceName());
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    private void relocateWorkspace(Environment authEnv, File locationDir) {
        Context.getLogger().info("Relocating workspace '" + this.getWorkspaceName() + "'...");
        Commandline cmdline = this.buildAccurevCmd("chws").addArgValue("-w").addArgValue(this.getWorkspaceName()).addArgValue("-l").addArgValue(locationDir.getAbsolutePath());
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    void reactivateStream(Environment authEnv, String streamName) {
        Context.getLogger().info("Reactivating stream '" + streamName + "'...");
        Commandline cmdline = this.buildAccurevCmd("reactivate").addArgValue("stream").addArgValue(streamName);
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    void deactivateStream(Environment authEnv, String streamName) {
        Context.getLogger().info("Deactivating stream '" + streamName + "'...");
        Commandline cmdline = this.buildAccurevCmd("remove").addArgValue("stream").addArgValue(streamName);
        cmdline.execute(authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
    }

    public Workspace getWorkspace(Environment authEnv, String workspaceName) {
        if (this.workspaceCache == null) {
            this.workspaceCache = new HashMap<String, Workspace>();
        }
        if (workspaceName == null) {
            workspaceName = this.getWorkspaceName() + "_" + this.getUserName();
        }
        if (this.workspaceCache.get(workspaceName) != null) {
            return this.workspaceCache.get(workspaceName);
        }
        Context.getLogger().info("Getting workspace by name '" + workspaceName + "'...");
        Commandline cmdline = this.buildAccurevCmd("show");
        cmdline.createArgument().setLine("-fix wspaces");
        Document doc = this.buildResponseDoc(cmdline, null, authEnv, null);
        Validate.notNull((Object)doc);
        Element element = (Element)doc.selectSingleNode("/AcResponse/Element[@Name=\"" + workspaceName + "\"]");
        if (element == null) {
            return null;
        }
        Workspace workspace = new Workspace();
        String hiddenAttr = element.attributeValue("hidden");
        workspace.setHidden(hiddenAttr != null && Boolean.valueOf(hiddenAttr) != false);
        workspace.setStreamNo(this.getStreamByName(authEnv, workspaceName).getBackStreamNumber());
        workspace.setDepotName(element.attributeValue("depot"));
        workspace.setHostName(element.attributeValue("Host"));
        workspace.setLocation(element.attributeValue("Storage"));
        workspace.setTransactionNo(Long.parseLong(element.attributeValue("Trans")));
        this.workspaceCache.put(workspaceName, workspace);
        return workspace;
    }

    public Stream getStreamByName(Environment authEnv, String streamName) {
        if (this.streamCache == null) {
            this.streamCache = new HashMap<String, Stream>();
        }
        if (this.streamCache.get(streamName) != null) {
            return this.streamCache.get(streamName);
        }
        Context.getLogger().info("Getting stream by name '" + streamName + "'...");
        Commandline cmdline = this.buildAccurevCmd("show").addArgLine("-fix -s ").addArgValue(streamName).addArgValue("streams");
        try {
            SAXReader saxReader = new SAXReader(false);
            final StringBuffer buffer = new StringBuffer();
            final boolean[] failed = new boolean[]{false};
            Commandline.ExecuteResult result = cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.trim().length() != 0) {
                        buffer.append(line.trim() + "\n");
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    if (line.trim().length() != 0) {
                        if (line.startsWith("Unknown stream")) {
                            buffer.append("<streams/>");
                        } else {
                            Context.getLogger().error(line);
                            failed[0] = true;
                        }
                    }
                }
            });
            if (failed[0]) {
                throw result.buildException();
            }
            Document doc = saxReader.read((Reader)new StringReader(buffer.toString()));
            Element element = (Element)doc.selectSingleNode("/streams/stream");
            if (element == null) {
                return null;
            }
            Stream stream = new Stream();
            stream.setName(streamName);
            stream.setNumber(Long.valueOf(element.attributeValue("streamNumber")));
            stream.setDepotName(element.attributeValue("depotName"));
            stream.setBackStreamName(element.attributeValue("basis"));
            String backStreamNumber = element.attributeValue("basisStreamNumber");
            if (backStreamNumber != null) {
                stream.setBackStreamNumber(Long.parseLong(backStreamNumber));
            }
            stream.setType(Stream.Type.valueOf(element.attributeValue("type")));
            String hiddenAttr = element.attributeValue("hidden");
            stream.setHidden(hiddenAttr != null && Boolean.parseBoolean(hiddenAttr));
            String timeAttr = element.attributeValue("time");
            if (timeAttr != null) {
                stream.setDate(new Date(Long.parseLong(timeAttr) * 1000L));
            }
            this.streamCache.put(streamName, stream);
            return stream;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private Transaction getTransactionByName(Environment authEnv, String depotName, String transactionName) {
        Context.getLogger().info("Getting transaction by name '" + transactionName + "'...");
        Commandline cmdline = this.buildAccurevCmd("hist");
        cmdline.createArgument().setValue("-p");
        cmdline.createArgument().setValue(depotName);
        cmdline.createArgument().setLine("-ftx -t");
        cmdline.createArgument().setValue(transactionName);
        Document doc = this.buildResponseDoc(cmdline, null, authEnv, null);
        Validate.notNull((Object)doc);
        Element element = (Element)doc.selectSingleNode("/AcResponse/transaction");
        if (element == null) {
            throw new QuickbuildException("Can not find transaction '" + transactionName + "' in depot '" + depotName + "'.");
        }
        Transaction transaction = new Transaction();
        transaction.setNumber(Long.parseLong(element.attributeValue("id")));
        transaction.setDate(new Date(Long.parseLong(element.attributeValue("time")) * 1000L));
        return transaction;
    }

    Document buildResponseDoc(Commandline cmdline, File workingDir, Environment authEnv, Set<Integer> validReturnCodes) {
        try {
            SAXReader saxReader = new SAXReader(false);
            final StringBuffer buffer = new StringBuffer();
            Commandline.ExecuteResult result = cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    buffer.append(line.trim() + "\n");
                }
            }, (LineConsumer)new LineConsumer.WarnLogger());
            if (validReturnCodes == null) {
                result.checkReturnCode();
            } else if (!validReturnCodes.contains(result.getReturnCode())) {
                throw result.buildException();
            }
            if (buffer.length() > 10000000) {
                Context.getLogger().warn("Can not parse XML as it is too large.");
                return null;
            }
            return saxReader.read((Reader)new StringReader(buffer.toString()));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void labelOnRevision(AccurevRevision revision, String label, String comment) {
        File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
        try {
            Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
            Stream stream = this.getStreamByName(authEnv, this.getStreamName());
            if (stream == null) {
                throw new QuickbuildException("Can not find stream named by '" + this.getStreamName() + "'...");
            }
            if (stream.getType() == Stream.Type.snapshot) {
                Stream snapshot = this.getStreamByName(authEnv, label);
                if (snapshot != null) {
                    if (snapshot.isHidden()) {
                        this.reactivateStream(authEnv, label);
                    }
                    if (!snapshot.getDate().equals(stream.getDate())) {
                        throw new QuickbuildException("Failed to create snapshot '" + label + "' as this name has already been used by another snapshot " + "which is created against a different transaction.");
                    }
                } else {
                    Stream parentStream = stream;
                    do {
                        Validate.notNull((Object)parentStream.getBackStreamName());
                        parentStream = this.getStreamByName(authEnv, parentStream.getBackStreamName());
                        Validate.notNull((Object)parentStream);
                    } while (parentStream.getType() == Stream.Type.snapshot);
                    this.createSnapshot(authEnv, label, parentStream.getName(), DATETIME_FORMATTER.print((ReadableInstant)new DateTime((Object)stream.getDate())));
                }
            } else {
                Stream snapshot = this.getStreamByName(authEnv, label);
                if (snapshot != null) {
                    if (snapshot.isHidden()) {
                        this.reactivateStream(authEnv, label);
                    }
                    Transaction transaction = this.getTransactionByName(authEnv, snapshot.getDepotName(), revision.toString());
                    if (!snapshot.getDate().equals(transaction.getDate())) {
                        throw new QuickbuildException("Failed to create snapshot '" + label + "' as this name has already been used by another snapshot " + "which is created against a different transaction.");
                    }
                } else {
                    this.createSnapshot(authEnv, label, stream.getName(), revision.toString());
                }
            }
        }
        finally {
            this.removeAuthDir(authDir, this.getUserName());
        }
    }

    public SourceViewSupport<AccurevRevision> getSourceViewSupport() {
        return new AccurevSourceViewSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isQuietSince(Date date) {
        File authDir = this.createAuthDir(this.getUserName(), this.getPassword());
        try {
            block7: {
                String buildStreamName = this.getStreamName();
                Environment authEnv = this.createAuthEnv(authDir, this.getUserName(), this.getPassword());
                Stream stream = this.getStreamByName(authEnv, buildStreamName);
                if (stream == null) {
                    throw new QuickbuildException("Can not find stream named by '" + buildStreamName + "'.");
                }
                do {
                    Commandline cmdline = this.buildAccurevCmd("hist").addArgLine("-a -s").addArgValue(stream.getName()).addArgValue("-t").addArgValue(DATETIME_FORMATTER.print((ReadableInstant)new DateTime()) + "-" + DATETIME_FORMATTER.print((ReadableInstant)new DateTime((Object)date)));
                    final Boolean[] changed = new Boolean[]{false};
                    cmdline.execute(authEnv, (OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            Context.getLogger().debug(line);
                            if (line.trim().startsWith("transaction")) {
                                changed[0] = true;
                            }
                        }
                    }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                    if (changed[0].booleanValue()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (stream.getDate() != null || stream.getBackStreamName() == null) break block7;
                } while ((stream = this.getStreamByName(authEnv, stream.getBackStreamName())) != null);
                throw new QuickbuildException("Can not find stream named by '" + this.getStreamName() + "'.");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.removeAuthDir(authDir, this.getUserName());
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element revisionElement = dom.getRootElement().element("revision");
        if (revisionElement != null) {
            revisionElement.setName("transactionNumber");
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (dom.getRootElement().element("referenceTreeName") == null) {
            dom.getRootElement().addElement("referenceTreeName").setText("qb-${node.hostName}-${current.locationDirId}");
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        Element referenceTreeNameElement = dom.getRootElement().element("referenceTreeName");
        referenceTreeNameElement.setName("referenceTreeNameProvider");
        String referenceTreeName = referenceTreeNameElement.getText().trim();
        referenceTreeNameElement.clearContent();
        referenceTreeNameElement.addElement("repository").addAttribute("reference", "../..");
        if (referenceTreeName.equals("qb-${node.hostName}-${current.locationDirId}")) {
            referenceTreeNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.accurev.NodeAndDirBasedReferenceTreeName");
        } else {
            referenceTreeNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.accurev.SpecifiedReferenceTreeName").addElement("referenceTreeName").setText(referenceTreeName);
        }
    }

    private void migrate5(VersionedDocument dom, Stack<Integer> versions) {
        Element referenceTreeNameProviderElement = dom.getRootElement().element("referenceTreeNameProvider");
        referenceTreeNameProviderElement.setName("workspaceNameProvider");
        String className = referenceTreeNameProviderElement.attributeValue("class");
        className = StringUtils.replace((String)className, (String)"NodeAndDirBasedReferenceTreeName", (String)"NodeAndDirBasedWorkspaceName");
        className = StringUtils.replace((String)className, (String)"SpecifiedReferenceTreeName", (String)"SpecifiedWorkspaceName");
        referenceTreeNameProviderElement.addAttribute("class", className);
        Element referenceTreeNameElement = referenceTreeNameProviderElement.element("referenceTreeName");
        if (referenceTreeNameElement != null) {
            referenceTreeNameElement.setName("workspaceName");
        }
    }

    private void migrate6(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("environments");
    }
}

